unit OC_CD;

interface

uses
  Windows, SysUtils, MMSystem;

function CloseCD(Drive : Char) : Boolean;
function OpenCD(Drive : Char) : Boolean;

implementation

function OpenCD(Drive : Char) : Boolean;
Var
  Res : MciError;
  OpenParm: TMCI_Open_Parms;
  Flags : DWord;
  S : String;
  DeviceID : Word;
begin
  Result:=false;
  S:=Drive+':';
  Flags:=mci_Open_Type or mci_Open_Element;
  With OpenParm do begin
    dwCallback := 0;
    lpstrDeviceType := 'CDAudio';
    lpstrElementName := PChar(S);
  end;
  Res := mciSendCommand(0, mci_Open, Flags, Longint(@OpenParm));
  IF Res<>0 Then exit;
  DeviceID:=OpenParm.wDeviceID;
  try
    Res:=mciSendCommand(DeviceID, MCI_SET, MCI_SET_DOOR_OPEN, 0);
    IF Res=0 Then exit;
    Result:=True;
  finally
    mciSendCommand(DeviceID, mci_Close, Flags, Longint(@OpenParm));
  end;
end;

function CloseCD(Drive : Char) : Boolean;
Var
  Res : MciError;
  OpenParm: TMCI_Open_Parms;
  Flags : DWord;
  S : String;
  DeviceID : Word;
begin
  Result:=false;
  S:=Drive+':';
  Flags:=mci_Open_Type or mci_Open_Element;
  With OpenParm do begin
    dwCallback := 0;
    lpstrDeviceType := 'CDAudio';
    lpstrElementName := PChar(S);
  end;
  Res := mciSendCommand(0, mci_Open, Flags, Longint(@OpenParm));
  IF Res<>0 Then exit;
  DeviceID:=OpenParm.wDeviceID;
  try
    Res:=mciSendCommand(DeviceID, MCI_SET, MCI_SET_DOOR_CLOSED, 0);
    IF Res=0 Then exit;
    Result:=True;
  finally
    mciSendCommand(DeviceID, mci_Close, Flags, Longint(@OpenParm));
  end;
end;


end.