unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin;

type
  TForm1 = class(TForm)
    Memo1: TMemo; //Files to be processed
    Label1: TLabel;
    Memo2: TMemo; //Strings which lines (when occur) are skipped
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    Button2: TButton;
    Memo3: TMemo; //state of progress
    Memo4: TMemo; //dummy to save output (condensed)
    Memo5: TMemo; //dummy to save output
    CheckBox1: TCheckBox;
    Memo6: TMemo;
    Label5: TLabel;
    ComboBox1: TComboBox;
    Label6: TLabel;
    SpinEdit1: TSpinEdit;
    Label7: TLabel;
    Label8: TLabel;
    Button3: TButton; //dummy to read the files
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
     close;
     application.terminate;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     memo1.Clear;
     memo1.Lines.Append('e:\logwws1.txt');
     memo1.Lines.Append('e:\logwws2.txt');
     memo1.Lines.Append('e:\logwws4.txt');
     memo1.Lines.Append('e:\logwws5.txt');
     memo1.Lines.Append('e:\logwws6.txt');
     memo1.Lines.Append('e:\logwws7.txt');
     memo1.Lines.Append('e:\logwws9.txt');
     memo2.Clear;
     memo2.Lines.Append('End Of File');
     memo2.Lines.Append('administrator');
     memo2.Lines.Append('Administrator');
     memo3.Clear;
     memo3.lines.append('Ready');
     memo4.Clear;
     memo5.Clear;
     memo6.Clear;
     edit1.Text:='parallel.tmp';
     edit2.Text:='parallel.log';
     checkbox1.Checked:=true;
end;

function gettime(x:string):longint;
var h,m,s,i,check:longint;
begin
     check:=1;
     val(copy(x,64,2),h,i); if i<>0 then check:=0;
     val(copy(x,67,2),m,i); if i<>0 then check:=0;
     val(copy(x,70,2),s,i); if i<>0 then check:=0;
     result:=(h*3600+m*60+s)*check;
end;

function gettimes(x:string):string;
begin
     result:=copy(x,64,8);
end;

function getdate(x:string):longint;
const mont:array[1..12] of string=('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

var m,y,d,check,i:longint;
begin
     m:=0;
     check:=1;
     repeat inc(m);
     until copy(x,57,3)=mont[m];
     val(copy(x,61,2),d,i); if i<>0 then check:=0;
     val(copy(x,73,4),y,i); if i<>0 then check:=0;
     result:=((y*12*31)+((m-1)*31)+d)*check;
end;

function getdates(x:string):string;
const mont:array[1..12] of string=('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

var m,y,d,check,i:longint;
    mo,ye,da:string;
begin
     m:=0;
     check:=1;
     repeat inc(m);
     until copy(x,57,3)=mont[m];
     if m>12 then check:=0;
     str(m:2,mo);
     da:=copy(x,61,2);
     ye:=copy(x,75,4);
     result:=da+'.'+mo+'.'+ye;
     if check=0 then result:='error';
end;

function getws(x:string):string;
begin
     x:=copy(x,33,20);
     if pos('\\',x)<>0 then delete(x,pos('\\',x),2);
     result:=x;
end;

function wospaces(x:string):string;
begin
     while x[length(x)]=' ' do delete(x,length(x),1);
     result:=x;
end;

function getuser(x:string):string;
begin
     result:=copy(x,1,16);
end;


procedure parse_condensed;
var i,j,k:integer;
    user,resu,dif,da:string;
    diff:longint;
begin
     with form1 do begin
          memo6.clear;
//load data into dummy memo
          memo6.lines.AddStrings(memo4.lines);
          for i:=0 to memo6.lines.count-1 do begin
              for j:=i to memo6.lines.count-1 do begin
                  if getuser(memo6.lines[j])=getuser(memo6.lines[i]) then begin
//this is the case is if we find new entry (same user)
                   if wospaces(getws(memo6.lines[j]))<>wospaces(getws(memo6.lines[i])) then begin
//only if another workstation...->"parallel" logon
                     if getdate(memo6.lines[j])=getdate(memo6.lines[i]) then begin
//check if same date
                        diff:=abs(gettime(memo6.lines[i])-gettime(memo6.lines[j]));
                        if diff<spinedit1.Value then begin
//NTLast16 works from last to .... entry
//only if difference between logons is below one hour
                           str((diff div 60):5,dif);
                           resu:=' at '+gettimes(memo6.lines[i])+' on '+wospaces(getws(memo6.lines[i]))+ ' and at '+gettimes(memo6.lines[j])+' on '+wospaces(getws(memo6.lines[j]));
//Should be changed. some spinedit components could help
                        end;
                     end;
                   end;
                  end;
              end;
              memo5.lines.append(dif+' min ->'+ wospaces(getuser(memo6.lines[i]))+' '+resu+ ' {'+getdates(memo6.lines[i])+'}');
          end;
     end;
end;

function emptyl(x:string):boolean;
begin
     result:=(copy(x,1,17)=('                 '));
end;

procedure sorttime;
var ct,i,index:integer;
    dummy:string;

function getval(x:string):integer;
var f:integer;
    arr:array of array[1..2] of integer;
begin
     val(copy(x,1,5),result,f);
end;

begin
     with form1 do begin
 {    setlength(arr,memo5.lines.count);
     for i:=0 to memo5.lines.count do begin
         arr[i][2]:=getval(memo5.lines[i]);
         arr[i][1]:=i;
     end;           }

     ct:=memo5.lines.count;
          repeat
          dummy:=memo5.lines[0]; index:=0;
          for i:=1 to ct-1 do begin
              if getval(memo5.lines[i])>getval(dummy) then begin
                 dummy:=memo5.lines[i];
                 index:=i;
              end;
          end;
          memo5.lines[index]:=memo5.lines[ct-1];
          memo5.lines[ct-1]:=dummy;
          dec(ct);
          until ct<=1;
     end;
end;

procedure beginparse;
var found,_strings,skipempty:boolean;
    i,j,k:integer;
    driv,fi1,fi2:string;
begin
     _strings:=false;
     skipempty:=false;
     with form1 do begin
          memo3.clear;
          memo4.Clear;
          memo5.Clear;
          memo6.Clear;
          memo3.Lines.Append('Starting process...');
          if length(edit1.text)=0 then begin
             edit1.Text:='parallel.tmp';
             memo3.Lines.Append('Found no name for condensed output file using default!');
          end;
          if length(edit2.text)=0 then begin
             edit2.Text:='parallel.log';
             memo3.Lines.Append('Found no name for output file using default!');
          end;
          if memo2.Lines.Count=0 then memo3.Lines.Append('No strings to filter - skipping option') else _strings:=true;
          if memo1.Lines.Count=0 then memo3.Lines.Append('No input logfiles are given - action cancelled!') else begin
//main()

//in every case delete the dummy memo for condensed o/p
             memo4.Clear;
             if checkbox1.Checked then begin
                memo3.Lines.Append('Will skip empty lines...');
                skipempty:=true;
             end else
                memo3.Lines.Append('Also empty lines will be taken from input (not recommended)');

                for i:=0 to memo1.lines.Count-1 do begin
                    if fileexists(memo1.lines[i]) then begin
                       memo6.lines.LoadFromFile(memo1.lines[i]);
//loaded logfile
                       for j:=0 to memo6.Lines.Count-1 do begin
                           if skipempty then begin
                              if not emptyl(memo6.lines[j]) then begin
                                 if _strings then begin
                                    found:=false;
                                    for k:=0 to memo2.Lines.Count-1 do if pos(memo2.lines[k],memo6.lines[j])<>0 then found:=true;
                                    if not found then memo4.lines.Append(memo6.lines[j]);
                                 end else memo4.lines.Append(memo6.lines[j]);
                              end;
                           end else begin
                                 if _strings then begin
                                    found:=false;
                                    for k:=0 to memo2.Lines.Count-1 do if pos(memo2.lines[k],memo6.lines[j])<>0 then found:=true;
                                    if not found then memo4.lines.Append(memo6.lines[j]);
                                 end else memo4.lines.Append(memo6.lines[j]);
                           end;
//if empty line nothing happens
//end for j
                       end;
                    memo6.Clear;
//if file does not exist ->msg
                    end else memo3.lines.Append('File "'+memo1.Lines[i]+'" does not exist - skipping it!');
//end for i
                end;
             fi1:=edit1.Text;
             fi2:=edit2.Text;
             driv:=combobox1.Text;
             if  driv<>'' then begin
                 if pos(driv,fi1)=0 then fi1:=driv+'\'+fi1;
                 if pos(driv,fi2)=0 then fi2:=driv+'\'+fi2;

             end;
             memo4.Lines.SaveToFile(fi1);
             getdate(memo4.lines[1]);
             parse_condensed;
             sorttime;
             memo5.Lines.SaveToFile(fi2);
          end;
          memo3.lines.append('Finished parsing process!');
     end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
     beginparse;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
     form2.show;
end;

end.
