{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

                                 _\\|//_
                                (` * * ')
 ______________________________ooO_(_)_Ooo_____________________________________
 LEGAL STUFF:
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 Copyright (c) 1998-2002, -=Assarbad=- ["copyright holder(s)"]
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
 3. The name(s) of the copyright holder(s) may not be used to endorse or
    promote products derived from this software without specific prior written
    permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
                             .oooO     Oooo.
 ____________________________(   )_____(   )___________________________________
                              \ (       ) /
                               \_)     (_/
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

program binres_test;

uses
  windows,
  shellapi;

{$R binres.res}

function ExtractResTo(Instance: hInst; BinResName, NewPath, ResType: string):
  boolean;
(*******************************************************************************
 Function:   ExtractResTo
 Returns:    Boolean (true=success)
 Version:    Function version 3.0

 Parameters
 Instance:   is the instance handle of the module containing the resource. if not
             current module, use LLoadLibrary() and FreeLibrary() to load and free
             the module containing the resource.
 BinResName: is the name of the resource to extract. this would even work with
             icons, cursors, texts, yaddayadda ...
 NewPath:    path of the file to create from the resource (where to put the
             file)
 ResType:    resource type. pre-defined values can be found in Windows.pas
             e.g. RT_RCDATA
 *******************************************************************************)
var
  ResSize,
    HG,
    HI,
    SizeWritten,
    hFileWrite: Cardinal;
begin
  result := false;
  HI := FindResource(Instance, @binresname[1], @ResType[1]);
  if HI <> 0 then begin
    HG := LoadResource(Instance, HI);
    if HG <> 0 then
    try
      ResSize := SizeOfResource(Instance, HI);
      hFileWrite := CreateFile(@newpath[1], GENERIC_READ or GENERIC_WRITE,
        FILE_SHARE_READ or FILE_SHARE_WRITE, nil, CREATE_ALWAYS,
        FILE_ATTRIBUTE_ARCHIVE, 0);
      if hFileWrite <> INVALID_HANDLE_VALUE then
      try
        result := (WriteFile(hFileWrite, LockResource(HG)^, ResSize,
          SizeWritten, nil) and (SizeWritten = ResSize));
      finally
        CloseHandle(hFileWrite);
      end;
    except;
    end;
  end;
end;

const
  newpath = 'test.bat';
  resname = 'BATfile';
  restype = 'BINRES';
begin
  if ExtractResTo(hInstance, resname, newpath, restype) then
    shellexecute(0, 'open', newpath, nil, nil, SW_SHOWNORMAL);
  Sleep(1000);
  DeleteFile(@newpath[1]);
end.

