(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2001 by -=Assarbad=-                ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

program errormsg;
uses
  windows,
  messages;

{$R main.res}
{$R icon.res}
{$INCLUDE ATOI.pas}

const
  IDD_DIALOG1 = 101;
  IDC_EDIT1 = 1000;
  IDC_EDIT2 = 1001;
  rand = 10;
  nosucherror = '[Program error:] No such error code.';

var
  appIcon, fix8, edit1_brush, edit2_brush: Cardinal;
  edit1_LogBrush: TLogBrush = (
    lbStyle: BS_SOLID;
    lbColor: $440000;
    lbHatch: 0);

  edit2_LogBrush: TLogBrush = (
    lbStyle: BS_SOLID;
    lbColor: $000000;
    lbHatch: 0);


function GetErrorMessage(code: Integer): string;
var
  hErrLib: DWORD;
  msg: PChar;
  flags: integer;

  function MAKELANGID(p, s: word): Integer;
  begin
    result := (s shl 10) or p
  end;

begin
  hErrLib := LoadLibraryEx('NETMSG.DLL', 0, LOAD_LIBRARY_AS_DATAFILE);
  try
    flags := FORMAT_MESSAGE_ALLOCATE_BUFFER or FORMAT_MESSAGE_IGNORE_INSERTS or FORMAT_MESSAGE_FROM_SYSTEM;
    case (hErrLib <> 0) of
      false: flags := flags or FORMAT_MESSAGE_FROM_HMODULE;
    end;
    case FormatMessage(flags, pointer(hErrLib), code, integer((SUBLANG_DEFAULT shl 10) or LANG_NEUTRAL), @msg, 0, nil) of
      0: result := '';
    else setstring(result, msg, lstrlen(msg));
    end;
    LocalFree(Integer(msg));
  finally
    if hErrLib <> 0 then FreeLibrary(hErrLib)
  end
end;

procedure seterrortext(hwnd: Cardinal);
var
  temp: string;
  code: Cardinal;
  buffer: array[0..6] of char;
  err: Cardinal;
begin
  getdlgitemtext(hwnd, IDC_EDIT1, @buffer[0], sizeof(buffer));
  val(buffer, code, err);
  case err of
    0: temp := GetErrorMessage(code);
  end;
  if temp = '' then temp := nosucherror;
  setdlgitemtext(hwnd, IDC_EDIT2, @temp[1]);
end;

function EditWindowProc2(hWnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
begin
  case Msg of
    WM_CHAR, WM_PASTE, WM_CUT, WM_RBUTTONDOWN: result := 0;
    WM_KEYDOWN:
      case wParam of
        VK_DELETE, VK_INSERT: result := 0;
      else
        result := CallWindowProc(pointer(GetProp(hWnd, 'OrigWndProc')), hWnd, Msg, wParam, lParam);
      end;
  else
    result := CallWindowProc(pointer(GetProp(hWnd, 'OrigWndProc')), hWnd, Msg, wParam, lParam);
  end;
end;

procedure seteditwndproc(hwnd: HWND; ptr: Pointer);
begin
  SetProp(hWnd, 'OrigWndProc', DWORD(SetWindowLong(hwnd, GWL_WNDPROC, Integer(ptr))));
end;

function dlgfunc(hwnd: hwnd; umsg: dword; wparam: wparam; lparam: lparam): bool; stdcall;
var
  rect: TRect;
begin
  result := true;
  case umsg of
    WM_INITDIALOG:
      begin
        SendMessage(hwnd, WM_SETICON, ICON_SMALL, appIcon);
        SendMessage(hwnd, WM_SETICON, ICON_BIG, appIcon);
        fix8 := CreateFont(-MulDiv(8, GetDeviceCaps(GetWindowDC(hwnd), LOGPIXELSY), 72), 0, 0, 0, FW_NORMAL, 0, 0, 0, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH or FF_MODERN, 'Courier New');
        sendmessage(Getdlgitem(hwnd, IDC_EDIT1), WM_SETFONT, fix8, Integer(TRUE));
        sendmessage(Getdlgitem(hwnd, IDC_EDIT2), WM_SETFONT, fix8, Integer(TRUE));
        sendmessage(Getdlgitem(hwnd, IDOK), WM_SETFONT, fix8, Integer(TRUE));
        sendmessage(Getdlgitem(hwnd, IDC_EDIT2), EM_GETRECT, 0, integer(@rect));
        rect.Left := rect.Left + rand;
        rect.Top := rect.Top + rand;
        rect.Right := rect.Right - rand;
        rect.Bottom := rect.Bottom - rand;
        sendmessage(Getdlgitem(hwnd, IDC_EDIT1), EM_LIMITTEXT, 6, 0);
        sendmessage(Getdlgitem(hwnd, IDC_EDIT2), EM_SETRECT, 0, integer(@rect));
        SetDlgItemInt(hwnd, IDC_EDIT1, 0, false);
        seteditwndproc(Getdlgitem(hwnd, IDC_EDIT2), @EditWindowProc2);
      end;
    WM_CLOSE:
      EndDialog(hWnd, 0);
    WM_CTLCOLOREDIT:
      case GetDlgCtrlID(lParam) of
        IDC_EDIT1:
          begin
            SetTextColor(wParam, RGB($FF, $FF, $00));
            SetBkColor(wParam, edit1_LogBrush.lbColor);
            result := BOOL(edit1_brush);
          end;
        IDC_EDIT2:
          begin
            SetTextColor(wParam, RGB($00, $FF, $00));
            SetBkColor(wParam, edit2_LogBrush.lbColor);
            result := BOOL(edit2_brush);
          end;
      end;
    WM_COMMAND:
      case hiword(wparam) of
        BN_CLICKED:
          case loword(wparam) of
            IDOK:
              seterrortext(hwnd);
          end;
      end;
  else result := false;
  end;
end;

begin
  edit1_brush := CreateBrushIndirect(edit1_LogBrush);
  edit2_brush := CreateBrushIndirect(edit2_LogBrush);
  appIcon := LoadIcon(hInstance, MAKEINTRESOURCE(1));
  DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_DIALOG1), 0, @DlgFunc, 0);
end.

