(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 1998-2002 by -=Assarbad=-           ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

                                 _\\|//_
                                (` * * ')
 ______________________________ooO_(_)_Ooo_____________________________________
 LEGAL STUFF:
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 Copyright (c) 1998-2002, -=Assarbad=- & Eugen Honeker ["copyright holder(s)"]
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
 3. The name(s) of the copyright holder(s) may not be used to endorse or
    promote products derived from this software without specific prior written
    permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
                             .oooO     Oooo.
 ____________________________(   )_____(   )___________________________________
                              \ (       ) /
                               \_)     (_/
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

program KickUser;
uses windows,
  messages;

{$INCLUDE compilerswitches.PAS}
{$R icon.res}
{$R main.res}

const
  TimerID = 666;
  IDD_DIALOG1 = 101;
  IDC_STATIC_TIME = 1000;
  IDC_STATIC_DESC = 1001;
  IDC_STATIC_TITLE = 1002;
  DIALOG_MAIN = IDD_DIALOG1;
  WM_MYMSG = WM_USER + TimerID; // wParam = time left in seconds

var
  hTimer: THandle;
  hTimer2: THandle;
  hThread: THandle;
  ThreadID: Cardinal;
  hDlg: HWND;
  canclose: Boolean = False;
  timeleft: DWORD;
  desktoprect: TRect;

function GetFont(hwnd: Cardinal; pointsize, weight: integer; fixedwidth: boolean{$IFDEF DELPHI4UP} = false{$ENDIF}): THandle;
(*
  Functionality:
    This function returns the handle to the specified font, either Courier or
    Arial.
    [SEMI-SPECIFIC]
*)
const
  arial = 'Arial';
  courier = 'Courier New';
var
  DC: HDC;
begin
  // Get DC
  DC := GetWindowDC(hwnd);
  case fixedwidth of
    true:
      // Create font w/ fixed width (eg.: Courier)
      result := CreateFont(-MulDiv(pointsize, GetDeviceCaps(DC, LOGPIXELSY),
        72), 0, 0, 0, weight,
        0, 0, 0, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS,
        PROOF_QUALITY, FIXED_PITCH or
        FF_MODERN, @courier[1]);
  else
      // Create font w/ variable width (eg.: Arial)
    result := CreateFont(-MulDiv(pointsize, GetDeviceCaps(DC, LOGPIXELSY), 72),
      0, 0, 0, weight,
      0, 0, 0, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY,
      VARIABLE_PITCH or
      FF_DONTCARE, @arial[1]);
  end;
  // Free DC
  ReleaseDC(hwnd, DC);
end;

function Format(fmt: string; params: array of const): string;
var
  pdw1, pdw2: PDWORD;
  i: integer;
  pc: PCHAR;
begin
  pdw1 := nil;
  if length(params) > 0 then GetMem(pdw1, length(params) * sizeof(Pointer));
  pdw2 := pdw1;
  for i := 0 to high(params) do begin
    pdw2^ := DWORD(PDWORD(@params[i])^);
    inc(pdw2);
  end;
  GetMem(pc, 1024 - 1);
  try
    SetString(Result, pc, wvsprintf(pc, PCHAR(fmt), PCHAR(pdw1)));
  except
    Result := '';
  end;
  if (pdw1 <> nil) then FreeMem(pdw1);
  if (pc <> nil) then FreeMem(pc);
end;

function HoldOnDesktop(hwnd: hwnd; umsg: Cardinal; wparam: wparam; lparam: lparam; snapping: boolean): bool;
//FUNCTION um das Fenster innerhalb der WORKAREA zu halten.
const
  defaultsnapgridsize = 10;
var
  size: TSize;
  snapgridsize: integer;
begin
  case snapping of
    true: snapgridsize := defaultsnapgridsize;
  else snapgridsize := 0;
  end;
  size.cx := PRECT(lParam).right - PRECT(lParam).left;
  size.cy := PRECT(lParam).bottom - PRECT(lParam).top;
  if PRECT(lParam).left < desktoprect.Left + snapgridsize then begin
    PRECT(lParam).left := desktoprect.Left;
    PRECT(lParam).right := PRECT(lParam).left + size.cx;
  end;
  if PRECT(lParam).right > desktoprect.Right - snapgridsize then begin
    PRECT(lParam).right := desktoprect.Right;
    PRECT(lParam).left := PRECT(lParam).right - size.cx;
  end;
  if PRECT(lParam).top < desktoprect.top + snapgridsize then begin
    PRECT(lParam).top := desktoprect.top;
    PRECT(lParam).bottom := PRECT(lParam).top + size.cy;
  end;
  if PRECT(lParam).bottom > desktoprect.bottom - snapgridsize then begin
    PRECT(lParam).bottom := desktoprect.bottom;
    PRECT(lParam).top := PRECT(lParam).bottom - size.cy;
  end;
  result := true;
end;

function ChangeDisp(hwnd: hwnd; umsg: Cardinal; wparam: wparam; lparam: lparam): bool;
var rect: TRect;

  procedure doit;
  begin
    SystemParametersInfo(SPI_GETWORKAREA, 0, @desktoprect, 0);
    GetWindowrect(hwnd, rect);
    MoveWindow(hwnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, false);
  end;

begin
  result := TRUE;
  case umsg of
    WM_DISPLAYCHANGE: doit;
    WM_SETTINGCHANGE:
      case wParam of
        SPI_SETWORKAREA:
          doit;
      end;
  else result := FALSE;
  end;
end;

function dlgfunc(hwnd: HWND; umsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL; stdcall;
var s: string;
begin
  case umsg of
    WM_INITDIALOG:
      begin
        hDlg := hwnd;
        SendDlgItemMessage(hwnd, IDC_STATIC_TIME, WM_SETFONT, GetFont(hwnd, 32, FW_BOLD, true), Ord(True));
        HideCaret(GetDlgItem(hwnd, IDC_STATIC_TIME));
      end;
    WM_CLOSE:
      if canclose then
        EndDialog(hwnd, 0);
    WM_CTLCOLORDLG:
      begin
        result := BOOL(GetStockObject(BLACK_BRUSH));
      end;
    WM_LBUTTONDOWN:
      sendmessage(hwnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam);
    WM_CTLCOLORSTATIC:
      case GetDlgCtrlID(lParam) of
        IDC_STATIC_TIME:
          begin
            SetBkMode(wParam, TRANSPARENT);
            SetTextColor(wParam, RGB($FF, 0, 0));
            result := BOOL(GetStockObject(BLACK_BRUSH));
          end;
        IDC_STATIC_DESC:
          begin
            SetBkMode(wParam, TRANSPARENT);
            SetTextColor(wParam, RGB($88, $FF, $88));
            result := BOOL(GetStockObject(BLACK_BRUSH));
          end;
      else
        begin
          SetBkMode(wParam, TRANSPARENT);
          SetTextColor(wParam, RGB(0, 0, $FF));
          result := BOOL(GetStockObject(BLACK_BRUSH));
        end;
      end;
    WM_MOVING:
      result := HoldOnDesktop(hwnd, umsg, wparam, lparam, false);
    WM_DISPLAYCHANGE,
      WM_SETTINGCHANGE:
      result := changedisp(hwnd, umsg, wparam, lparam);
    WM_MYMSG:
      begin
        s := Format('%2.2d:%2.2d', [wParam div 60, wParam mod 60]);
        SetDlgItemText(hDlg, IDC_STATIC_TIME, @s[1]);
        case ((wParam < 30) and (wParam > 0)) of
          true: windows.Beep(2000, 150);
        end;
        if wParam = 0 then
        begin
          windows.Beep(2000, 1000);
          canclose := true;
          SendMessage(hwnd, WM_CLOSE, 0, 0);
        end;
      end;
  else
    result := false;
  end;
end;

function ThreadFunc(p: Pointer): DWORD; stdcall;
begin
  DialogBoxParam(hInstance, MAKEINTRESOURCE(DIALOG_MAIN), 0, @dlgfunc, 0);
end;

function shut(force: boolean; FLAGS: DWORD = 0): integer;
var
  otoken, hToken: THandle;
  tp: TTokenPrivileges;
  h: Dword;
  ch: char;
const
  SE_SHUTDOWN_NAME = 'SeShutdownPrivilege';
begin
  OpenProcessToken(GetCurrentProcess, TOKEN_ADJUST_PRIVILEGES, hToken);
  otoken := htoken;
  LookupPrivilegeValue(nil, SE_SHUTDOWN_NAME, tp.Privileges[0].luid);
  tp.privilegecount := 1;
  tp.privileges[0].Attributes := SE_PRIVILEGE_ENABLED;
  h := 0;
  AdjustTokenPrivileges(hToken, False, tp, 0, PTokenPrivileges(nil)^, h);
  case force of
    TRUE: ExitWindowsEx(FLAGS or EWX_FORCE, 0);
    FALSE: ExitWindowsEx(FLAGS, 0);
  end;
  result := getlasterror;
  tp.privilegecount := 1;
  tp.privileges[0].Attributes := SE_PRIVILEGE_ENABLED;
  h := 0;
  AdjustTokenPrivileges(oToken, False, tp, 0, PTokenPrivileges(nil)^, h);
  CloseHandle(hToken);
end;

function GetDuration: DWORD;
// get duration from registry in case of error use 15 minutes as default
const
  defduration = 900000; // 15 min in milliseconds
var key: HKEY;
  duration: DWORD;
  size: integer;
begin
  result := defduration; // default duration
  if RegOpenKeyEx(HKEY_CURRENT_USER, 'Software\Kickuser', 0, KEY_READ, key) = ERROR_SUCCESS then
  begin
    size := sizeof(duration);
    if RegQueryValueEx(key, 'Duration', nil, nil, PByte(@duration), @size) = ERROR_SUCCESS then
      result := duration;
  end;
end;

function dummywndproc(hwnd: HWND; umsg: UINT; wparam: WPARAM; lparam: LPARAM): LRESULT; stdcall;
var duration: Cardinal;
const second = 1000; //milliseconds
begin
  result := 0;
  case umsg of
    WM_CREATE:
      begin
        duration := GetDuration;
        hTimer := SetTimer(hwnd, TimerID, duration, nil);
        timeleft := duration;
        hTimer2 := SetTimer(hwnd, TimerID + 1, second, nil);
      end;
    WM_TIMER:
      case wParam of
        TimerID: // time-out for duration stuff ;)
          begin
            canclose := True;
            SendMessage(hwnd, WM_CLOSE, 0, 0); //shut(true, EWX_LOGOFF); // this could be called multiple times ...
          end;
        TimerID + 1: // every second
          begin
            timeleft := timeleft - second;
            PostMessage(hDlg, WM_MYMSG, timeleft div second, 0);
          end;
      end;
    WM_CLOSE:
      if canclose then
        PostQuitMessage(0);
  else
    Result := DefWindowProc(hWnd, uMsg, wParam, lParam);
  end;
end;

// void Main()
var osinfo: TOSVersionInfo;
  wndclass: TWndClassEx =
  (
    cbSize: sizeof(TWndClassEx);
    style: CS_HREDRAW or CS_VREDRAW;
    lpfnWndProc: @dummywndproc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    lpszClassName: 'WndClassDummyLogoff';
    );
  wnd: HWND = 0;
  msg: TMsg;

begin
  osinfo.dwOSVersionInfoSize := sizeof(TOSVERSIONinfo);
  if BOOL(GetVersionEx(osinfo)) then
    if osinfo.dwPlatformId <> VER_PLATFORM_WIN32_NT then exit;
  wndclass.hInstance := hInstance;
  wndclass.hbrBackground := GetStockObject(WHITE_BRUSH);
  SystemParametersInfo(SPI_GETWORKAREA, 0, @desktoprect, 0);
  if RegisterClassEx(wndclass) <> 0 then
  begin
    wnd := CreateWindowEx(0, wndclass.lpszClassName, 'TrayClockWClass', 0, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, 0, nil);
    //message loop
    hThread := CreateThread(nil, 0, @ThreadFunc, nil, 0, ThreadID); //CREATE_SUSPENDED ,
    while GetMessage(msg, wnd, 0, 0) do // get any pending window messages for our window
    begin
      TranslateMessage(msg); // translate them
      DispatchMessage(msg); // dispatch them
      Sleep(0);
    end;
  end;
  // log off without notice immediately ... (this will also happen if window was not created!!!)
  shut(true, EWX_LOGOFF);
end.

