program LocalIP;

uses
  Windows,
  Messages,
  ShellAPI,
  NetworkServices;

{$R finfo.res}

const WM_SHELLNOTIFY=WM_USER+666;
      ClassName='LocalIPWinClass';
      AppName='IP monitor';
      SC_TRAY=WM_USER+666-2;
      SC_RESTORE=WM_USER+666-1;
      SC_HELP=WM_USER+666+1;
      SC_ABOUT=WM_USER+666+2;
      ID_TIMER=1;
      windowwidth:dword=160;
      windowheight:dword=80;
      edtheight=18;
      localIPstr='IP address: ';
      MAIN_ICON=128;

var note:TNotifyIconData;
    edit1,hsysmenu,hpopmenu:Dword;
    dpchar,dpchar2:pchar;
    rect:trect;
    oldip:string;
    currIP:string='000.000.000.000';
    timer:dword=0;

function WndProc(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): LRESULT; stdcall;
var pt:tpoint;
    myfont,dc:DWORD;
    rect:TRect;
    ps:tpaintstruct;

begin
  Result:=0;
  case uMsg of
      WM_CREATE:
         begin
           hsysmenu:=GetSystemMenu(hWnd,FALSE);
           if hsysmenu<>0 then begin
             DeleteMenu(hsysmenu,SC_MAXIMIZE,MF_BYCOMMAND);
             DeleteMenu(hsysmenu,SC_RESTORE,MF_BYCOMMAND);
             DeleteMenu(hsysmenu,SC_SIZE,MF_BYCOMMAND);
             Appendmenu(hsysmenu,MF_SEPARATOR,0,nil);
             Appendmenu(hsysmenu,MF_BYCOMMAND,SC_HELP,pchar('Help'));
             Appendmenu(hsysmenu,MF_BYCOMMAND,SC_ABOUT,pchar('About this program'));
           end;
           hpopmenu:=createpopupmenu;
           AppendMenu(hPopMenu,MF_STRING,SC_RESTORE,'Restore');
           AppendMenu(hPopMenu,MF_SEPARATOR,0,nil);
           AppendMenu(hPopMenu,MF_STRING,SC_HELP,'Help');
           AppendMenu(hPopMenu,MF_STRING,SC_ABOUT,'About');
           AppendMenu(hPopMenu,MF_SEPARATOR,0,nil);
           AppendMenu(hPopMenu,MF_STRING,SC_CLOSE,'Close');
           getclientrect(hwnd,rect);
           dc:=getwindowdc(hwnd);
           Myfont:=CreateFont(-MulDiv(8, GetDeviceCaps(DC,LOGPIXELSY),72),
                              0,0,0,400,0,0,0,DEFAULT_CHARSET,OUT_TT_PRECIS,
                              $10,2,4,'MS Sans Serif');
           releasedc(hwnd,dc);
           edit1:=CreateWindowEx(WS_EX_CLIENTEDGE,
                            pchar('Edit'),
                            nil,
                            WS_CHILD
                            or WS_VISIBLE
                            or ES_CENTER
                            or ES_AUTOHSCROLL
                            or ES_READONLY
                            or WS_TABSTOP,
                            ((rect.Right-rect.Left) div 5)*2-1,
                            ((rect.Bottom-rect.Top) div 2)-(edtheight div 2),
                            ((rect.Right-rect.Left) div 5)*3,
                            edtheight,
                            hWnd,
                            1,
                            hInstance,
                            nil);
           sendmessage(edit1,WM_SETFONT,myfont,0);
           currIP:=localIPf;
           setdlgitemtext(hwnd,1,pchar(currip));
           lstrcpy(note.szTip, pchar(localIPstr+currip));
           oldIP:=currIP;
           timer:=SetTimer(hWnd,ID_TIMER,3000,nil);
         end;
      WM_TIMER:
         begin
              currip:=localIPf;
              if oldip<>currip then begin
                 setdlgitemtext(hwnd,1,pchar(currip));
                 lstrcpy(note.szTip, pchar(localIPstr+currip));
                 oldip:=currip;
              end;
         end;
      WM_DESTROY:
         begin
              if timer<>0 then killtimer(hwnd,timer);
              Shell_NotifyIcon(NIM_DELETE,@note);
              PostQuitMessage(0);
         end;
      WM_SIZE:
         if wParam = SIZE_MINIMIZED then begin
            note.cbSize:=SizeOf(TNotifyIconData);
            note.Wnd   :=hWnd;
            note.uID   :=SC_TRAY;
            note.uFlags:=NIF_ICON or NIF_MESSAGE or NIF_TIP;
            note.uCallbackMessage:=WM_SHELLNOTIFY;
            note.hIcon :=GetClassLong(hWnd,GCL_HICON);
            lstrcpy(note.szTip, pchar(localIPstr+currip));
            ShowWindow(hWnd, SW_HIDE);
            Shell_NotifyIcon(NIM_ADD,@note);
         end;
      WM_NCHITTEST:
         begin
              result:=DefWindowProc(hWnd,uMsg,wParam,lParam);
              if result=HTCLIENT then result:=HTCAPTION
         end;
      WM_PAINT:
         begin
              dc:=beginpaint(hwnd,ps);
              getclientrect(hwnd,rect);
              Myfont:=CreateFont(-MulDiv(8, GetDeviceCaps(DC,LOGPIXELSY),72),
                                 0,0,0,400,0,0,0,DEFAULT_CHARSET,OUT_TT_PRECIS,
                                 $10,2,4,'MS Sans Serif');
              SetBkMode(dc,TRANSPARENT);
              settextcolor(dc,$000000FF);
              SelectObject(dc,myfont);
              drawtext(dc,pchar(localIPstr),-1,rect,dt_singleline or dt_left or dt_vcenter);
              endpaint(hwnd,ps)
         end;
      WM_COMMAND:
         if lParam=0 then begin
            if LoWord(wParam)=SC_RESTORE then begin
               Shell_NotifyIcon(NIM_DELETE,@note);
               ShowWindow(hWnd, SW_RESTORE)
            end else
            if LoWord(wParam)=SC_ABOUT then begin
               sendmessage(hwnd,WM_SYSCOMMAND,SC_ABOUT,0);
            end else
            if LoWord(wParam)=SC_HELP then begin
               sendmessage(hwnd,WM_SYSCOMMAND,SC_HELP,0);
            end else
            if LoWord(wParam)=SC_CLOSE then begin
               Shell_NotifyIcon(NIM_DELETE,@note);
               sendmessage(hwnd,WM_SYSCOMMAND,SC_CLOSE,0);
            end;
         end;
      WM_SYSCOMMAND:
         begin
              case wParam of
              SC_ABOUT:
                begin
                     getmem(dpchar,2048);
                     loadstring(hinstance,1,dpchar,2048);
                     MessageBox(hWnd,dpchar,pchar(AppName+' 2000 by -=Assarbad=-      '),MB_OK);
                     freemem(dpchar,2048);
                end;
              SC_HELP:
                begin
                     getmem(dpchar,2048);
                     loadstring(hinstance,2,dpchar,2048);
                     getmem(dpchar2,2048);
                     loadstring(hinstance,3,dpchar2,2048);
                     dpchar:=lstrcat(dpchar,dpchar2);
                     MessageBox(hWnd,dpchar,pchar(AppName+' 2000 by -=Assarbad=-      '),MB_OK);
                     freemem(dpchar,2048);
                     freemem(dpchar2,2048);
                end;
              else Result:=DefWindowProc(hWnd,uMsg,wParam,lParam);//inherited
              end;//case wParam of
         end;
      WM_SHELLNOTIFY:
         if wParam=SC_TRAY then begin
            case lParam of
                WM_RBUTTONDOWN:
                   begin
                        GetCursorPos(pt);
                        SetForegroundWindow(hWnd);
                        TrackPopupMenu(hPopMenu, TPM_RIGHTALIGN or TPM_RIGHTBUTTON,
                                       pt.x,pt.y,0,hWnd,nil);
                        PostMessage(hWnd,WM_NULL,0,0);
                   end;
                  WM_LBUTTONDBLCLK:
                     SendMessage(hWnd,WM_COMMAND,SC_RESTORE,0);
            end;
         end;
  else
      Result:=DefWindowProc(hWnd,uMsg,wParam,lParam);
  end;
end;

var wc:TWndClassEx=(
      cbSize       : SizeOf(TWndClassEx);
      style        : CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      lpfnWndProc  : @WndProc;
      cbClsExtra   : 0;
      cbWndExtra   : 0;
      lpszMenuName : nil;
      lpszClassName: ClassName;
      hIconSm      : 0;);
    msg: TMsg;

begin
      systemparametersinfo(SPI_GETWORKAREA,0,@rect,0);
      wc.hinstance:=hinstance;
      wc.hIcon:=LoadIcon(HInstance,MAKEINTRESOURCE(MAIN_ICON));
      wc.hcursor:=loadcursor(0,idc_arrow);
      wc.hbrBackground:=GetStockObject(BLACK_BRUSH);
      registerclassex(wc);
      createwindowex(WS_EX_TOPMOST,classname,appname,
                     WS_VISIBLE or WS_BORDER or WS_SYSMENU or WS_MINIMIZEBOX,
                     rect.Left,rect.Top, windowwidth, windowheight, 0, 0, hinstance,
                     nil);
      while true do begin
            if not getmessage(msg,0,0,0) then
               break;
            translatemessage(msg);
            dispatchmessage(msg);
      end;
      exitcode:=getlasterror;
end.
