unit NetworkServices;
interface
uses winsock, windows;

function localIPf:string;

implementation

type tapinaddr=array [0..10] of pinaddr;
     papinaddr=^tapinaddr;

var ginitdata:twsadata;
    dllhandle:hinst;
    err:dword;

const wsfile='wsock32.dll';

function localIPf:string;
var phe:phostent;
    pptr:papinaddr;
    hostn:array[0..63]of char;//Pchar will be more complicated
    i:integer;
begin
      result:='';
      gethostname(hostn,sizeof(hostn));
      phe:=gethostbyname(hostn);
      if phe=nil then exit;
      pptr:=papinaddr(phe^.h_addr_list);
      i:=0;
      while pptr^[i]<>nil do begin
            result:=string(inet_ntoa(pptr^[i]^));
            inc(i);
      end;
end;

function ipaddrtoname(ipaddr:string):string;
var sockaddrin:tsockaddrin;
    hostent:phostent;
begin
     sockaddrin.sin_addr.s_addr:=inet_addr(pchar(ipaddr));
     hostent:=gethostbyaddr(@sockaddrin.sin_addr.s_addr,4,af_inet);
     if hostent<>nil then
        result:=string(hostent^.h_name)
     else
        result:='';
end;

procedure initwinsock;
begin
      dllhandle:=loadlibrary(pchar(wsfile));
      err:=wsastartup($101, ginitdata);
      if err<>0 then begin
         MessageBox(0, 'Error initializing Winsock (Winsock not loaded)', 'Application error', MB_OK or MB_ICONSTOP or MB_TASKMODAL);
      end;
end;

procedure closewinsock;
begin
      wsacleanup;
      freelibrary(dllhandle);
      dllhandle:=0;
end;

initialization
    initwinsock;
finalization
    closewinsock;
end.

