(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 1998-2002 by -=Assarbad=-           ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

                                 _\\|//_
                                (` * * ')
 ______________________________ooO_(_)_Ooo_____________________________________
 LEGAL STUFF:
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 Copyright (c) 1998-2002, -=Assarbad=- ["copyright holder(s)"]
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
 3. The name(s) of the copyright holder(s) may not be used to endorse or
    promote products derived from this software without specific prior written
    permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
                             .oooO     Oooo.
 ____________________________(   )_____(   )___________________________________
                              \ (       ) /
                               \_)     (_/
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

(*******************************************************************************
 version 2.0

 - omitted some functions that are not necessary.
 - enhanced readkey. now waits for event, instead of polling for event.
 - the "std_*" variables can now be used outside InitConsole.
 - SetTextAttribute now returns the old text attributes in a word.
   The behavior is transparent, since Delphi allows functions to be called like
   procedures (without taking back any return value).
 *******************************************************************************)

var
  std_input,
    std_output,
    std_error: THandle;

procedure InitConsole;
begin
  std_input := GetStdHandle(STD_INPUT_HANDLE);
  std_output := GetStdHandle(STD_OUTPUT_HANDLE);
  std_error := GetStdHandle(STD_ERROR_HANDLE);
  SetStdHandle(STD_ERROR_HANDLE, std_input);
end;

function TextAttribute: Word;
var
  csbi: _CONSOLE_SCREEN_BUFFER_INFO;
begin
  if GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), csbi) then
    result := csbi.wAttributes
  else
    result := 0;
end;

function SetTextAttribute(attr: word): word;
var
  oldattr: word;
begin
  oldattr := TextAttribute;
  if SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), attr) then
    result := oldattr
  else
    result := 0;
end;

procedure ClrScr;
var
  tc: tcoord;
  nw: Cardinal;
  cbi: TConsoleScreenBufferInfo;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), cbi);
  tc.x := 0;
  tc.y := 0;
  FillConsoleOutputAttribute(GetStdHandle(STD_OUTPUT_HANDLE), textattribute, cbi.dwsize.x * cbi.dwsize.y, tc, nw);
  FillConsoleOutputCharacter(GetStdHandle(STD_OUTPUT_HANDLE), #32, cbi.dwsize.x * cbi.dwsize.y, tc, nw);
  SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), tc);
end;

function WhereX: Integer;
var
  cbi: TConsoleScreenBufferInfo;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), cbi);
  result := TCoord(cbi.dwCursorPosition).x + 1
end;

function WhereY: Integer;
var
  cbi: TConsoleScreenBufferInfo;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), cbi);
  result := TCoord(cbi.dwCursorPosition).y + 1
end;

procedure GotoXY(const x, y: integer);
var
  coord: TCoord;
begin
  coord.x := x - 1;
  coord.y := y - 1;
  SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), coord);
end;

procedure FlushInputBuffer;
begin
  FlushConsoleInputBuffer(GetStdHandle(STD_INPUT_HANDLE))
end;

function ReadKey: Char;
var
  NumRead: Cardinal;
  InputRec: TInputRecord;
  ConHandle: THandle;
begin
  ConHandle := GetStdHandle(STD_INPUT_HANDLE);
  while not (
    (WaitForSingleObject(ConHandle, INFINITE) = WAIT_OBJECT_0) and
    ReadConsoleInput(ConHandle, InputRec, 1, NumRead) and
    (InputRec.EventType = KEY_EVENT)) do
    ;
  Result := InputRec.Event.KeyEvent.AsciiChar;
  FlushConsoleInputBuffer(ConHandle);
end;

function Keypressed: boolean;
var
  NumberOfEvents: Cardinal;
begin
  GetNumberOfConsoleInputEvents(GetStdHandle(STD_INPUT_HANDLE), NumberOfEvents);
  result := NumberOfEvents <> 0;
end;

