(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 1998-2002 by -=Assarbad=-           ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

                                 _\\|//_
                                (` * * ')
 ______________________________ooO_(_)_Ooo_____________________________________
 LEGAL STUFF:
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 Copyright (c) 1998-2002, -=Assarbad=- ["copyright holder(s)"]
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
 3. The name(s) of the copyright holder(s) may not be used to endorse or
    promote products derived from this software without specific prior written
    permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
                             .oooO     Oooo.
 ____________________________(   )_____(   )___________________________________
                              \ (       ) /
                               \_)     (_/
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

{
PURPOSE:
  include file for creating and running a service!

VERSION
1.2

- reviewed the complete code and adapted it to the rest of my code base.
}



{$APPTYPE CONSOLE}
const
  cmd_install = 'Attempting to install "' + servicename + '" as a';
  cmd_installed = '"%s" was successfully %sinstalled';
  press_anykey = #13#10#13#10 + 'Press any key to continue.';
  cmd_header = servicename + ' - (c) 2001 by -=Assarbad=-' + #13#10#13#10;
  cmd_syntax = 'Syntax : %s [/command+parameter]'#13#10#13#10 +
    'Commands are single characters:'#13#10 +
    'I'#9'Installs "' + servicename + '" as a service'#13#10 +
    #9'Parameter:'#13#10 +
    #9#9'A = Auto start, M = Manual start'#13#10 +
    'U'#9'Uninstalls "' + servicename + '"'#13#10 +
    press_anykey;
  un_text = 'un';

var
  dispatchtable: array[0..1] of tservicetableentry;
  sshstatushandle: service_status_handle;
  ssstatus: service_status;
  stopped: boolean;
  paused: boolean;
  param: string;
  currtextattr: word;
  modname: array[0..MAX_PATH - 1] of char;
  hSCM,
    hService: SC_HANDLE;
  startupmode: integer;
  svc_runflags: DWORD = SERVICE_WIN32_OWN_PROCESS or SERVICE_INTERACTIVE_PROCESS;

{$INCLUDE .\Include\GetErrorMessage.pas}
{$INCLUDE .\Include\FormatString.pas}

procedure FatalError;
begin
  currtextattr := textattribute;
  settextattribute(FOREGROUND_RED or FOREGROUND_INTENSITY);
  writeln('Error!');
  settextattribute(currtextattr);
  writeln(Geterrormessage(getlasterror));
  halt;
end;

procedure servicehandler(fdwcontrol: integer); stdcall;
begin
  case fdwcontrol of
    SERVICE_CONTROL_STOP:
      begin
        stopped := true;
        ssstatus.dwcurrentstate := service_stop_pending;
        setservicestatus(sshstatushandle, ssstatus);
      end;
    SERVICE_CONTROL_PAUSE:
      begin
        paused := true;
        ssstatus.dwcurrentstate := service_paused;
        setservicestatus(sshstatushandle, ssstatus);
      end;
    SERVICE_CONTROL_CONTINUE:
      begin
        paused := false;
        ssstatus.dwcurrentstate := service_running;
        setservicestatus(sshstatushandle, ssstatus);
      end;
    SERVICE_CONTROL_INTERROGATE:
      setservicestatus(sshstatushandle, ssstatus);
    SERVICE_CONTROL_SHUTDOWN:
      stopped := true;
  end;
end;

procedure serviceproc(dwargc: integer; var lpszargv: pchar); stdcall;
begin
  sshstatushandle := registerservicectrlhandler(@servicename[1], @servicehandler);
  if (sshstatushandle <> 0) then
    begin
      zeromemory(@ssstatus, sizeof(ssstatus));
      ssstatus.dwservicetype := SERVICE_WIN32_OWN_PROCESS;
      ssstatus.dwcurrentstate := SERVICE_START_PENDING;
      ssstatus.dwcontrolsaccepted := SERVICE_ACCEPT_STOP or SERVICE_ACCEPT_PAUSE_CONTINUE;
      ssstatus.dwwaithint := 1000;
      setservicestatus(sshstatushandle, ssstatus);
      stopped := false;
      paused := false;
      ssstatus.dwcurrentstate := SERVICE_RUNNING;
      setservicestatus(sshstatushandle, ssstatus);
      SERVICE_MAIN;
      ssstatus.dwcurrentstate := SERVICE_STOPPED;
      setservicestatus(sshstatushandle, ssstatus);
    end;

end;

procedure showsyntax;
begin
  write(frmt(cmd_syntax, [@modname[0]]));
  //  readkey;
end;

procedure startasservice;
begin
  dispatchtable[0].lpservicename := @servicename[1];
  dispatchtable[0].lpserviceproc := @serviceproc;
  dispatchtable[1].lpservicename := nil;
  dispatchtable[1].lpserviceproc := nil;
  startservicectrldispatcher(dispatchtable[0]);
end;

procedure PROG_MAIN;
begin
  case paramcount of
    0: startasservice;
  else
    begin
      GetModuleFileName(hInstance, @modname[0], MAX_PATH);
      Getlasterror;
      param := paramstr(1);
      case param[1] = '/' of
        true:
          begin
            currtextattr := textattribute;
            settextattribute(FOREGROUND_GREEN or FOREGROUND_INTENSITY);
            writeln(cmd_header);
            settextattribute(currtextattr);
            case param[2] of
              'I', 'i':
                begin
                  currtextattr := textattribute;
                  settextattribute(FOREGROUND_BLUE or FOREGROUND_INTENSITY);
                  StartupMode := SERVICE_DEMAND_START;
                  if length(param) > 2 then
                    case param[3] of
                      'A', 'a': startupMode := SERVICE_AUTO_START; // automatic
                    end
                  else
                    StartupMode := SERVICE_DEMAND_START; // manual
                  case startupMode of
                    SERVICE_AUTO_START: writeln(cmd_install + 'n autostart service');
                    SERVICE_DEMAND_START: writeln(cmd_install + ' manual start service');
                  end;
                  settextattribute(currtextattr);
                  hSCM := OpenSCManager(nil, nil, SC_MANAGER_ALL_ACCESS);
                  case hSCM of
                    0: FatalError;
                  else
                    begin
                      hService := CreateService(hSCM,
                        @ServiceName[1],
                        @DisplayName[1],
                        SERVICE_START or SERVICE_QUERY_STATUS or _DELETE,
                        svc_runflags,
                        StartupMode,
                        SERVICE_ERROR_NORMAL,
                        @modname[0],
                        nil, nil, nil, nil, nil);
                      case hService of
                        0:
                          begin
                            CloseServiceHandle(hSCM);
                            FatalError;
                          end;
                      else
                        begin
                          CloseServiceHandle(hSCM);
                          CloseServiceHandle(hService);
                          writeln(frmt(cmd_installed, [@servicename[1], nil]));
                        end;
                      end;
                    end;
                  end;
                end;
              'U', 'u':
                begin
                  currtextattr := textattribute;
                  settextattribute(FOREGROUND_BLUE or FOREGROUND_INTENSITY);
                  writeln('Attempting to uninstall "' + servicename + '"');
                  settextattribute(currtextattr);
                  hSCM := OpenSCManager(nil, nil, SC_MANAGER_ALL_ACCESS);
                  case hSCM of
                    0: FatalError;
                  else
                    begin
                      hService := OpenService(hSCM, @Servicename[1], SERVICE_ALL_ACCESS);
                      case hService of
                        0:
                          begin
                            CloseServiceHandle(hSCM);
                            FatalError;
                          end;
                      else
                        begin
                          startupMode := integer(DeleteService(hService));
                          CloseServiceHandle(hService);
                          CloseServiceHandle(hSCM);
                          case startupMode of
                            0: FatalError;
                          else
                            writeln(frmt(cmd_installed, [@servicename[1], @un_text[1]]));
                          end; //case
                        end;
                      end; //case
                    end;
                  end; //case
                end;
            else
              showsyntax;
            end; //case
          end;
        false: startasservice;
      end;
    end;
  end;
end;

