(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2000-2002 by -=Assarbad=-           ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

function FileExists(const FileName: string; dir: boolean{$IFDEF DELPHI4UP} = false{$ENDIF}):
  Boolean;
(****************************************************************
 function FileExists
 Rckgabewert: Boolean (existiert = TRUE)

 Funktion:
 berprft ob eine Datei oder ein Verzeichnis existiert.
 Entspricht weitestgehend der Funktion aus der Systutils.PAS.
 Siehe Delphi-Hilfe.
 ****************************************************************)
var
  hidate, lodate: word;
  Handle: THandle;
  FindData: TWin32FindData;
  LocalFileTime: TFileTime;

  function SubFileExists: Boolean;
  begin
    FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFileTime);
    result := FileTimeToDosDateTime(LocalFileTime, HiDate, LoDate);
  end;

begin
  result := false;
  Handle := FindFirstFile(PChar(FileName), FindData);
  if Handle <> INVALID_HANDLE_VALUE then
    begin
      Windows.FindClose(Handle);
      case dir of
        TRUE: if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) <> 0 then
            result := SubFileExists;
        FALSE: if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then
            result := SubFileExists;
      end;
    end;
end;

