(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2000-2002 by -=Assarbad=-           ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

const
  mrsIgnoreCase = $1;
  mrsReplaceAll = $2;

function MyExtAnsiUpperCase(s: string): string;
// Should even overcome #0 inside a string
var
  l: integer;
begin
  result := s;
  l := length(result);
  if l > 0 then CharUpperBuff(@Result[1], l);
end;

function MyExtAnsiLowerCase(const S: string): string;
// Should even overcome #0 inside a string
var
  l: integer;
begin
  result := s;
  l := length(result);
  if l > 0 then CharLowerBuff(@Result[1], l);
end;

function MyAnsiCompareText(const s1, s2: string): integer;
// Compares 2 strings ignoring #0-termination
begin
  result := CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE, @s1[1], length(s1), @s2[1], length(s2)) - 2;
end;

function XStrPos(Str1, Str2: PChar): PChar; assembler;
// Directly copied from SYSUTILS.PAS - just renamed for compatibility
asm
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        OR      EAX,EAX
        JE      @@2
        OR      EDX,EDX
        JE      @@2
        MOV     EBX,EAX
        MOV     EDI,EDX
        XOR     AL,AL
        MOV     ECX,0FFFFFFFFH
        REPNE   SCASB
        NOT     ECX
        DEC     ECX
        JE      @@2
        MOV     ESI,ECX
        MOV     EDI,EBX
        MOV     ECX,0FFFFFFFFH
        REPNE   SCASB
        NOT     ECX
        SUB     ECX,ESI
        JBE     @@2
        MOV     EDI,EBX
        LEA     EBX,[ESI-1]
@@1:    MOV     ESI,EDX
        LODSB
        REPNE   SCASB
        JNE     @@2
        MOV     EAX,ECX
        PUSH    EDI
        MOV     ECX,EBX
        REPE    CMPSB
        POP     EDI
        MOV     ECX,EAX
        JNE     @@1
        LEA     EAX,[EDI-1]
        JMP     @@3
@@2:    XOR     EAX,EAX
@@3:    POP     EBX
        POP     ESI
        POP     EDI
end;

function XAnsiPos(const Substr, s: string): integer;
var
  p: Pchar;
begin
  result := 0;
  p := XStrPos(@s[1], @substr[1]);
  if p <> nil then
    result := p - @s[1] + 1;
end;

function MyStringReplace(const s, old, new: string; flags: Cardinal = mrsReplaceAll): string;
var
  newstr, tosearch, pattern: string;
  offset: integer;
begin
  result := '';
  newstr := s;
  if (flags and mrsIgnoreCase) > 0 then begin
    tosearch := MyExtAnsiUpperCase(s);
    pattern := MyExtAnsiUpperCase(old);
  end
  else
  begin
    tosearch := s;
    pattern := old;
  end;
  while tosearch <> '' do
  begin
    Offset := XAnsiPos(pattern, tosearch);
    if Offset = 0 then
    begin
      Result := Result + NewStr;
      Break;
    end;
    result := result + copy(newstr, 1, offset - 1) + new;
    NewStr := Copy(newstr, offset + length(old), maxint);
    if (flags and mrsReplaceAll) = 0 then begin
      result := result + newstr;
      break;
    end;
    tosearch := copy(tosearch, offset + length(pattern), maxint);
  end;
end;

