(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2000-2002 by -=Assarbad=-           ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

 (*
Es fehlt noch:
  - Ausgabe in andere Datei
  - Kommandozeilenparameter -noGUI (um automatisch mit den gesicherten
                                    Einstellungen zu konvertieren)
  - Kommandozeilensupport
*)

program Umlautkonverter;

uses
  Windows,
  commdlg,
  Messages;

{DEFINE nogui}
{$INCLUDE .\Include\Compilerswitches.pas}
{$INCLUDE .\Include\Fileexists.pas}
{$INCLUDE .\Include\Getfont.pas}
{$INCLUDE .\Include\StringRoutines.pas}

{$R .\Resources\main.res}
{$R .\Resources\icon.res}

const
  check_off = 1000;
  editeven_off = 2000;
  editodd_off = 3000;

  IDD_DIALOG1 = 101;
  IDC_BUTTON1 = editodd_off + 97;
  IDC_EDIT1 = editodd_off + 98;
  IDC_EDIT2 = editeven_off + 1;
  IDC_EDIT3 = editodd_off + 1;
  IDC_EDIT4 = editeven_off + 2;
  IDC_EDIT5 = editodd_off + 2;
  IDC_EDIT6 = editeven_off + 3;
  IDC_EDIT7 = editodd_off + 3;
  IDC_EDIT8 = editeven_off + 4;
  IDC_EDIT9 = editodd_off + 4;
  IDC_EDIT10 = editeven_off + 5;
  IDC_EDIT11 = editodd_off + 5;
  IDC_EDIT12 = editeven_off + 6;
  IDC_EDIT13 = editodd_off + 6;
  IDC_EDIT14 = editeven_off + 7;
  IDC_EDIT15 = editodd_off + 7;
  IDC_EDIT16 = editeven_off + 8;
  IDC_EDIT17 = editodd_off + 8;
  IDC_EDIT18 = editeven_off + 9;
  IDC_EDIT19 = editodd_off + 9;
  IDC_EDIT20 = editeven_off + 10;
  IDC_EDIT21 = editodd_off + 10;
  IDC_EDIT22 = editeven_off + 11;
  IDC_EDIT23 = editodd_off + 11;

  IDC_EDIT24 = editeven_off + 12;
  IDC_EDIT25 = editodd_off + 12;
  IDC_EDIT26 = editeven_off + 13;
  IDC_EDIT27 = editodd_off + 13;

  IDC_CHECK1 = check_off + 1;
  IDC_CHECK2 = check_off + 2;
  IDC_CHECK3 = check_off + 3;
  IDC_CHECK4 = check_off + 4;
  IDC_CHECK5 = check_off + 5;
  IDC_CHECK6 = check_off + 6;
  IDC_CHECK7 = check_off + 7;
  IDC_CHECK8 = check_off + 8;
  IDC_CHECK9 = check_off + 9;
  IDC_CHECK10 = check_off + 10;
  IDC_CHECK11 = check_off + 11;
  IDC_CHECK12 = check_off + 12;
  IDC_CHECK13 = check_off + 13;
  IDC_STATIC_TEXT = editodd_off + 99;
  IDC_CHECKOUT = editodd_off + 100;

  IDC_STATIC = -1;
  filterstring =
    'HTML files'#0'*.htm;*.html'#0'Text files'#0'*.txt'#0'All files'#0'*.*'#0#0;
  max_elems = 13;
  nogui_param = '-NOGUI'; //must be uppercase here
  createfileFailed = 'The creation/modification of the output file failed. Press OK to use another output-file. Press Cancel to cancel the processing.';
  defext='html';

var
  i: integer;
  noGUI: boolean = false;
  appIcon: HICON = 0;
  blackbrush: HBRUSH = 0;
  darkredbrush: HBRUSH = 0;
  ofn: TOpenFilename;
  globinfilename: string = '';
  globoutfilename: string = '';
  ofn_buffer: array[0..MAX_PATH] of char;

  BlackLogBrush: TLogBrush = //Vorinitialisierter schwarzer Brush
  (
    lbStyle: BS_SOLID;
    lbColor: $00000000;
    lbHatch: 0
    );

  DarkredLogBrush: TLogBrush = //Vorinitialisierter schwarzer Brush
  (
    lbStyle: BS_SOLID;
    lbColor: $00000033;
    lbHatch: 0
    );

  UmlautConfig: packed record
    check: array[1..max_elems] of boolean;
    occ,
      subst: array[1..max_elems] of array[0..MAX_PATH] of char;
  end =
  (
    check: (true, true, true, true, true, true, true, true, true, true, true, true,
    true);
    occ: ('&', '"', '', '', '', '', '', '', '', '<', '>', '', '');
    subst: ('&amp;', '&quot;', '&auml;', '&Auml;', '&ouml;', '&Ouml;', '&uuml;',
    '&Uuml;',
    '&szlig;', '&lt;', '&gt;', '&copy;', '&reg;');
    );

function WriteStringToFile(fname, text: string{$IFDEF DELPHI4UP}; nooverwrite: boolean =
  FALSE{$ENDIF}): BOOL;
{
Result = TRUE means success
"fname" is the name of the (text-)file
"text" is the text to write into the file

Note: This would in any case overwrite an existing file
      EXCEPTION: on Delphi 4+ you may specify "nooverwrite" with TRUE to prevent
      this behavior and cause the function to return FALSE!
      Most probably you'll need to include SYSUTILS.PAS

      The respective compiler directives should be declared somewhere. On a
      system without the directives the function defaults to its Delphi 2/3 (-)
      behavior.
}
var
  SizeWritten, hFileWrite: {$IFDEF DELPHI4UP}Cardinal{$ELSE}Integer{$ENDIF};
  x: pchar;
begin
  result := FALSE;
{$IFDEF DELPHI4UP}
  if nooverwrite then
    if fileexists(fname) then
      exit;
{$ENDIF}
  hFileWrite := CreateFile(@fname[1], GENERIC_READ or GENERIC_WRITE, FILE_SHARE_READ or
    FILE_SHARE_WRITE, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_ARCHIVE, 0);
  if hFileWrite <> INVALID_HANDLE_VALUE then
    try
      x := @text[1];
      WriteFile(hFileWrite, x^, length(text), SizeWritten, nil);
      result := TRUE;
    finally
      CloseHandle(hFileWrite);
    end;
end;

function ReadStringFromFile(fname: string; var text: string): BOOL;
{
Result = TRUE means success
"fname" is the name of the (text-)file
"text" is the text read from the file
}
var
  hFileRead, hMapFile: Cardinal;
  pc: pchar;
begin
  result := FALSE;
  hFileRead := CreateFile(@fname[1], GENERIC_READ, 0, nil, OPEN_EXISTING,
    FILE_ATTRIBUTE_ARCHIVE, 0);
  if hFileRead <> INVALID_HANDLE_VALUE then
    try
      hMapFile := CreateFileMapping(hFileRead, nil, PAGE_READONLY, 0, 0, nil);
      if hMapFile <> 0 then
        try
          pc := MapViewOfFile(hMapFile, FILE_MAP_READ, 0, 0, 0);
          if pc <> nil then
            try
              SetString(text, pc, lstrlen(pc));
              result := TRUE;
            finally
              UnmapViewOfFile(pc);
            end;
        finally
          CloseHandle(hMapFile);
        end;
    finally
      CloseHandle(hFileRead);
    end;
end;

function ConvertString(input: string): string;
var
  i: integer;
  temp1, temp2: string;
begin
  result := input;
  for i := 1 to length(UmlautConfig.check) do
    case UmlautConfig.check[i] of
      true:
        begin
          SetString(temp1, UmlautConfig.occ[i], lstrlen(@UmlautConfig.occ[i][0]));
          SetString(temp2, UmlautConfig.subst[i], lstrlen(@UmlautConfig.subst[i][0]));
          result := MyStringReplace(result, temp1, temp2, mrsReplaceAll);
        end;
    end;
end;

function dlgfunc(hwnd: hwnd; umsg: dword; wparam: wparam; lparam: lparam): bool; stdcall;
var
  i: integer;

  procedure putstringstoConfig;
  var
    i: integer;
  begin
    for i := 1 to length(UmlautConfig.check) do
      case UmlautConfig.check[i] of
        true:
          begin
            ZeroMemory(@UmlautConfig.occ[i][0], sizeof(UmlautConfig.occ[i]));
            GetDlgItemText(hwnd, editeven_off + i, @UmlautConfig.occ[i][0], sizeof(UmlautConfig.occ[i]));
            ZeroMemory(@UmlautConfig.subst[i][0], sizeof(UmlautConfig.subst[i]));
            GetDlgItemText(hwnd, editodd_off + i, @UmlautConfig.subst[i][0], sizeof(UmlautConfig.subst[i]));
          end;
      end;
  end;

  function getcheckbox(ID: integer): boolean;
  begin
    case IsDlgButtonChecked(hwnd, ID) of
      BST_CHECKED: result := true;
      else
        result := false;
    end;
  end;

  procedure setcheckbox(ID: integer; yes: boolean);
  var
    check: Cardinal;
  begin
    case yes of
      true: check := BST_CHECKED;
      else
        check := BST_UNCHECKED;
    end;
    CheckDlgButton(hwnd, ID, check);
  end;

procedure ConvertByConfig(input, output: string);
var
  html_content: string;
begin
  if ReadStringFromFile(input, html_content) then
    begin
      html_content := ConvertString(html_content);
      if getcheckbox(IDC_CHECKOUT) then output:='\'; //ungltig als Dateiname aber der Benutzer will ja ein Outputfile
      case output = '' of
        true:
          WriteStringToFile(input, html_content);
        else
          while not WriteStringToFile(output, html_content) do
            if messagebox(hwnd, @createfileFailed[1], nil, MB_OKCANCEL or MB_ICONERROR or MB_SETFOREGROUND) = IDOK then
              begin
                ofn.lStructSize := SizeOf(TOpenFilename);
                ofn.hWndOwner := hwnd;
                ofn.hInstance := HInstance;
                ofn.lpstrFilter := filterstring;
                ofn.lpstrFile := ofn_buffer;
                ofn.nMaxFile := sizeof(ofn_buffer);
                ofn.lpstrDefExt:=@defext[1];
                ofn.Flags := OFN_LONGNAMES or OFN_EXPLORER or OFN_HIDEREADONLY;
                if GetSaveFileName(ofn) then
                  SetString(output, ofn_buffer, lstrlen(@ofn_buffer[0]));
              end
            else
              exit;
      end;
    end;
end;

  procedure disablebyconfig;
  var
    i: integer;
  begin
    for i := 1 to length(UmlautConfig.check) do
      begin
        EnableWindow(GetDlgItem(hwnd, editeven_off + i), UmlautConfig.check[i]);
        EnableWindow(GetDlgItem(hwnd, editodd_off + i), UmlautConfig.check[i]);
      end;
  end;

  procedure filleditsfromconfig;
  var
    i: integer;
  begin
    for i := 1 to length(UmlautConfig.check) do
      begin
        SetDlgItemText(hwnd, editeven_off + i, @UmlautConfig.occ[i][0]);
        SetDlgItemText(hwnd, editodd_off + i, @UmlautConfig.subst[i][0]);
        setcheckbox(check_off + i, UmlautConfig.check[i]);
      end;
  end;

begin
  result := true;
  case umsg of
    WM_INITDIALOG:
      begin
        sendmessage(hwnd, WM_SETICON, ICON_BIG, appIcon);
        sendmessage(hwnd, WM_SETICON, ICON_SMALL, appIcon);

        fix10 := GetFont(hwnd, 10, true);
        senddlgitemmessage(hwnd, IDC_EDIT1, EM_LIMITTEXT, MAX_PATH, 0);
        senddlgitemmessage(hwnd, IDC_EDIT1, WM_SETFONT, fix10, ord(TRUE));
        for i := 1 to length(UmlautConfig.check) do
          begin
            senddlgitemmessage(hwnd, editodd_off + i, EM_LIMITTEXT, MAX_PATH, 0);
            senddlgitemmessage(hwnd, editeven_off + i, EM_LIMITTEXT, MAX_PATH, 0);
            senddlgitemmessage(hwnd, editodd_off + i, WM_SETFONT, fix10, ord(TRUE));
            senddlgitemmessage(hwnd, editeven_off + i, WM_SETFONT, fix10, ord(TRUE));
          end;
        filleditsfromconfig;
        disablebyconfig;
        SetDlgItemText(hwnd, IDC_EDIT1, @globinfilename[1]);
        if globoutfilename = '' then
          setcheckbox(IDC_CHECKOUT, false)
        else
          setcheckbox(IDC_CHECKOUT, true);
      end;
    WM_CLOSE:
      EndDialog(hWnd, 0);
    WM_CTLCOLOREDIT:
      case GetDlgCtrlID(lParam) of
        IDC_EDIT1:
          begin
            SetTextColor(wParam, RGB($EE, $EE, $EE));
            SetBkColor(wParam, DarkredLogBrush.lbColor);
            result := BOOL(Darkredbrush);
          end;

        IDC_EDIT2..IDC_EDIT27:
          begin
            SetTextColor(wParam, RGB($FF, $0, $0));
            SetBkColor(wParam, DarkredLogBrush.lbColor);
            result := BOOL(Darkredbrush);
          end;
      end;
    WM_CTLCOLORSTATIC:
      case GetDlgCtrlId(lParam) of
        IDC_STATIC_TEXT:
          begin
            SetTextColor(wParam, RGB(0, $CC, 0));
            SetBkColor(wParam, BlackLogBrush.lbColor);
            result := BOOL(blackbrush);
          end;
        IDC_STATIC,
          IDC_CHECKOUT:
          begin
            SetTextColor(wParam, RGB(0, 0, $FF));
            SetBkColor(wParam, BlackLogBrush.lbColor);
            result := BOOL(blackbrush);
          end;
        else
          begin
            SetTextColor(wParam, RGB($CC, $CC, $CC));
            SetBkColor(wParam, BlackLogBrush.lbColor);
            result := BOOL(Blackbrush);
          end;
      end;
    WM_CTLCOLORDLG:
      result := BOOL(blackbrush);
    WM_LBUTTONDOWN:
      sendmessage(hwnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam);
    WM_COMMAND:
      if hiword(wparam) = BN_CLICKED then
        begin
          case loword(wparam) of
            IDC_BUTTON1:
              begin
                ofn.lStructSize := SizeOf(TOpenFilename);
                ofn.hWndOwner := hwnd;
                ofn.hInstance := HInstance;
                ofn.lpstrFilter := filterstring;
                ofn.lpstrFile := ofn_buffer;
                ofn.nMaxFile := sizeof(ofn_buffer);
                ofn.Flags := OFN_PATHMUSTEXIST or OFN_LONGNAMES or OFN_EXPLORER or
                  OFN_HIDEREADONLY;
                if GetOpenFileName(ofn) then
                  begin
                    SetString(globinfilename, ofn_buffer, lstrlen(@ofn_buffer[0]));
                    SetDlgItemText(hwnd, IDC_EDIT1, @globinfilename[1]);
                  end;
              end;
            IDOK:
              begin
                putstringstoConfig;
                ConvertByConfig(globinfilename, globoutfilename);
              end;
            IDCLOSE:
              sendmessage(hwnd, WM_CLOSE, 0, 0);
            IDC_CHECK1..IDC_CHECK13:
              begin
                UmlautConfig.check[loword(wparam) - check_off] :=
                  getcheckbox(loword(wparam));
                disablebyconfig;
              end;
          end;
        end;
    else
      result := false;
  end;
end;

{
Syntax: [self] [options] [infile] [outfile]

Outfile always follows Infile.
Outfile is optional.

The only valid option will be:
  -noGUI
}
begin
  for i := 1 to paramcount do
    begin
      if MyExtAnsiUpperCase(paramstr(i)) = nogui_param then
        nogui := true
      else
        if Fileexists(paramstr(i)) then
          begin
            globinfilename := paramstr(i);
            globoutfilename := paramstr(i + 1);
            break;
          end;
    end;
{$IFNDEF nogui}
  if noGUI then
    begin
    end
  else
{$ENDIF nogui}
    begin
      appIcon := LoadIcon(hInstance, MAKEINTRESOURCE(1));
      Blackbrush := CreateBrushIndirect(BlackLogBrush);
      Darkredbrush := CreateBrushIndirect(DarkredLogBrush);
      DialogBox(HInstance, MAKEINTRESOURCE(IDD_DIALOG1), 0, @DlgFunc);
    end;
end.

