(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2001 by -=Assarbad=-                ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

function FileExists(const FileName: string; dir: boolean = false): Boolean;
var
  hidate, lodate: word;
  Handle: THandle;
  FindData: TWin32FindData;
  LocalFileTime: TFileTime;

type
  LongRec = packed record
    Lo, Hi: Word;
  end;

  function SubFileExists: Boolean;
  begin
    FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFileTime);
    result := FileTimeToDosDateTime(LocalFileTime, HiDate, LoDate);
  end;
begin
  result := false;
  Handle := FindFirstFile(PChar(FileName), FindData);
  if Handle <> INVALID_HANDLE_VALUE then
  begin
    Windows.FindClose(Handle);
    case dir of
      TRUE: if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) <> 0 then result := SubFileExists;
      FALSE: if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then result := SubFileExists;
    end;
  end;
end;