const
  wholepas = '<table bgcolor=#%6.6X border=0 width=100%%><tr><td><font face="Courier"><pre><tt><font size=%u>?</font></tt></pre></font></table>';
//1.: background color
//STRING: the whole pas-argument
  declpas = '<font color=#%6.6X><font size=%i>%s</font></font>';
  declpassm = '<font color=#%6.6X>%s</font>';
  stdsize = 2;
//1.: color
//2.: font size
//3.: bold/italic/underline - includes questionmark to replace!
//since the win api only supports buffers up to 1024 bytes for
//wvsprintf we have to use a trick, therefore: "?"

type
  Decltype =
    (
    dtNormsource, //normal source
    dtComment, //single lined comment
    dtKeyword, //keyword of PASCAL
    dtDirective, //standard directive of PASCAL
    dtString, //string
    dtAsmroutines,
    dtBackground
    );
var
  directives: array[0..36] of shortstring = (
    'absolute',
    'abstract',
    'assembler',
    'automated',
    'cdecl',
    'default',
    'dispid',
    'dynamic',
    'export',
    'external',
    'forward',
    'implements',
    'index',
    'message',
    'name',
    'nodefault',
    'overload',
    'override',
    'pascal',
    'private',
    'protected',
    'public',
    'published',
    'read',
    'readonly',
    'register',
    'reintroduce',
    'resident',
    'safecall',
    'stdcall',
    'stored',
    'virtual',
    'write',
    'writeonly',
    'package',
    'contains',
    'requires');
  keywords: array[0..63] of shortstring =
  ('and',
    'array',
    'as',
    'asm',
    'begin',
    'class',
    'case',
    'const',
    'constructor',
    'destructor',
    'dispinterface',
    'div',
    'do',
    'downto',
    'else',
    'end',
    'except',
    'exports',
    'file',
    'finalization',
    'finally',
    'for',
    'function',
    'goto',
    'if',
    'implementation',
    'in',
    'inherited',
    'initialization',
    'inline',
    'interface',
    'is',
    'label',
    'library',
    'mod',
    'nil',
    'not',
    'object',
    'of',
    'on',
    'or',
    'packed',
    'procedure',
    'program',
    'property',
    'raise',
    'record',
    'repeat',
    'set',
    'shl',
    'shr',
    'string',
    'then',
    'threadvar',
    'to',
    'try',
    'type',
    'unit',
    'until',
    'uses',
    'var',
    'while',
    'with',
    'xor');
  comments1: array[0..1] of shortstring = ('(*', '*)');
  comments2: array[0..1] of shortstring = ('{', '}');

  singlecomment: shortstring = '//';

  stylepas: array[dtNormsource..dtBackground] of record
    size: integer;
    color: Cardinal;
    bold,
      italic,
      underline: boolean;
  end =
  (
    (size: stdsize;
    color: $FFFF00), //dtNormsource, //normal source
    (size: stdsize;
    color: $C0C0C0), //dtComment, //single lined comment
    (size: stdsize;
    color: $FFFFFF), //dtKeyword, //keyword of PASCAL
    (size: stdsize;
    color: $FFFFFF), //dtDirective, //standard directive of PASCAL
    (size: stdsize;
    color: $00FFFF), //dtString, //string
    (size: stdsize;
    color: $00FF00), //Asm routines
    (size: stdsize;
    color: $000080) //background
    );

  stylestrings: array[dtNormsource..dtBackground] of string;
  delimiter: set of char = [#13, #10, #32, #9, ';', '=', '[', '(', ')', ']','.'];

//  directive_occur = set of char =   ['a','c','d','e','f','i','m','n','o','p','r','s','v','w'];
//  keyword_occur = set of char =     ['a','b','c','d','e','f','g','i','l','m','n','o','p','r','s','t','u','v','w','x'];
//  keywordonly_occur = set of char = ['b', 'g', 'l', 't', 'u', 'x'];

function pas2html(input: string): string;
var temp: string;
  chrptr: integer;

  procedure initstyles;
  var i: DeclType;
    j: integer;
    s: string;
    smaller: boolean;
  begin
    j := 0;
//checks if all sizes are the same ... if yes, saves space ;)
    for i := dtNormsource to dtBackground do
      j := j + stylepas[i].size;
    if j = stylepas[dtNormsource].size * (integer(dtBackground) + 1) then smaller := true else smaller := false;
    for i := dtNormsource to dtBackground do begin
      s := '?';
      if stylepas[i].bold then s := '<b>' + s + '</b>';
      if stylepas[i].italic then s := '<i>' + s + '</i>';
      if stylepas[i].underline then s := '<u>' + s + '</u>';
      case smaller of
        true:
          stylestrings[i] := frmt(declpassm, [pointer(stylepas[i].color), pchar(s)]);
        false:
          stylestrings[i] := frmt(declpas, [pointer(stylepas[i].color), pointer(stylepas[i].size), pchar(s)]);
      end;
    end;
  end;

  function replacestr(input, which, withwhich: string): string;
  var offset: integer;
  begin
    offset := pos(which, input);
    result := copy(input, 1, offset - 1) + withwhich + copy(input, offset + 1, length(input));
  end;

  function isequ(s: string): boolean;
  begin
    result := lstrcmpi(pchar(copy(input, chrptr, length(s))), pchar(s)) = 0;
  end;

  procedure doit(i1, i2: integer; dt: DeclType = dtNormSource);
  begin
    temp := temp + copy(input, 1, i1 - 1) + replacestr(stylestrings[dt], '?', copy(input, i1, i2 - i1 + 1));
    delete(input, 1, i2);
    chrptr := 1;
  end;

  function testString: boolean;
  var j: integer;
  begin
    result := true;
    if isequ('''') then begin
      j := chrptr;
      inc(chrptr);
      while chrptr < length(input) do
        if isequ('''') then begin
          if input[chrptr + 1] = '''' then inc(chrptr, 2) else begin
            doit(j, chrptr, dtString);
            break;
          end;
        end else inc(chrptr);
    end else
      if isequ('#') then begin
        j := chrptr;
        while input[chrptr + 1] in ['0'..'9', 'a'..'f', 'A'..'F', '#', '$'] do
          case input[chrptr + 1] of
            '#', '$': inc(chrptr);
          else inc(chrptr);
          end;
        doit(j, chrptr, dtString);
      end
      else result := false;
  end;

  function testDirective: boolean;
  var i: integer;
  begin
    result := false;
    for i := 0 to length(directives) - 1 do
      if isequ(directives[i]) then
        case chrptr of
          1: begin
              if input[chrptr + length(directives[i])] in delimiter then begin
                doit(chrptr, chrptr + length(directives[i]) - 1, dtdirective);
                result := true;
                break;
              end;
            end;
        else begin
            case chrptr + length(directives[i]) <= length(input) of
              true:
                if input[chrptr + length(directives[i])] in delimiter then
                  if input[chrptr - 1] in delimiter then begin
                    doit(chrptr, chrptr + length(directives[i]) - 1, dtdirective);
                    result := true;
                    break;
                  end;
              false:
                if input[chrptr - 1] in delimiter then begin
                  doit(chrptr, chrptr + length(directives[i]) - 1, dtdirective);
                  result := true;
                  break;
                end;
            end;
          end;
        end else result := false;
  end;

  function testKeyWord: boolean;
  var i: integer;

    procedure find_endof_asm;
    begin
      while chrptr < length(input) do
        case input[chrptr] of
          'a'..'z', 'A'..'Z':
            if isequ(Keywords[15]) then begin
              doit(1, chrptr - 1, dtAsmRoutines);
              break;
            end else inc(chrptr);
        else inc(chrptr);
        end;
    end;

  begin
    result := false;
    for i := 0 to length(keywords) - 1 do
      if isequ(keywords[i]) then begin
        case i of
          3:
            case chrptr of
              1: if input[chrptr + length(keywords[i])] in delimiter then begin
                  doit(chrptr, chrptr + length(keywords[i]) - 1, dtKeyword);
                  find_endof_asm;
                  result := true;
                  break;
                end;
            else begin
                case chrptr + length(keywords[i]) <= length(input) of
                  true:
                    if input[chrptr + length(keywords[i])] in delimiter then
                      if input[chrptr - 1] in delimiter then begin
                        doit(chrptr, chrptr + length(keywords[i]) - 1, dtKeyword);
                        find_endof_asm;
                        result := true;
                        break;
                      end;
                  false:
                    if input[chrptr - 1] in delimiter then begin
                      doit(chrptr, chrptr + length(keywords[i]) - 1, dtKeyword);
                      find_endof_asm;
                      result := true;
                      break;
                    end;
                end;
              end;
            end;
        else
          case chrptr of
            1: begin
                if input[chrptr + length(keywords[i])] in delimiter then doit(chrptr, chrptr + length(keywords[i]) - 1, dtKeyword);
              end;
          else begin
              case chrptr + length(keywords[i]) <= length(input) of
                true:
                  if input[chrptr + length(keywords[i])] in delimiter then
                    if input[chrptr - 1] in delimiter then begin
                      doit(chrptr, chrptr + length(keywords[i]) - 1, dtKeyword);
                      result := true;
                      break;
                    end;
                false:
                  if input[chrptr - 1] in delimiter then begin
                    doit(chrptr, chrptr + length(keywords[i]) - 1, dtKeyword);
                    result := true;
                    break;
                  end;
              end;
            end;
          end;
        end;
      end;
  end;

  function testforComment: boolean;
  var j: integer;
  begin
    result := false;
    if isequ(comments1[0]) then begin
      j := chrptr;
      while chrptr < length(input) do
        if isequ(comments1[1]) then begin
          doit(j, chrptr + length(comments1[1]) - 1, dtComment);
          result := true;
          break;
        end else inc(chrptr);
    end else
      if isequ(comments2[0]) then begin
        j := chrptr;
        while chrptr < length(input) do
          if isequ(comments2[1]) then begin
            doit(j, chrptr + length(comments2[1]) - 1, dtComment);
            result := true;
            break;
          end else inc(chrptr);
      end else
        if isequ(singlecomment) then begin
          j := chrptr;
          while chrptr < length(input) do
            if isequ(#13#10) then begin
              doit(j, chrptr - 1, dtComment);
              result := true;
              break;
            end else inc(chrptr);
        end;
  end;

begin
  initstyles;
  while pos('&', input) > 0 do input := replacestr(input, '&', #255);
//indirect exchange of '&' by '&amp;' BEFORE inserting new '&'s :)
  while pos(#255, input) > 0 do input := replacestr(input, #255, '&amp;');
  while pos('<', input) > 0 do input := replacestr(input, '<', '&lt;');
  while pos('>', input) > 0 do input := replacestr(input, '>', '&gt;');
  while pos('"', input) > 0 do input := replacestr(input, '"', '&quot;');

  chrptr := 1;
  temp := '';
  while chrptr <= length(input) do begin
    case input[chrptr] of
      '(', '{', '/': testforComment;
      '''', '#': testString;
      'a', 'c', 'd', 'e', 'f', 'i', 'm', 'n', 'o', 'p', 'r', 's', 'v', 'w',
        'A', 'C', 'D', 'E', 'F', 'I', 'M', 'N', 'O', 'P', 'R', 'S', 'V', 'W':
        if not testKeyWord then testDirective;
      'b', 'g', 'l', 't', 'u', 'x',
        'B', 'G', 'L', 'T', 'U', 'X':
        testKeyWord;
    end;
    inc(chrptr);
  end;
  result := replacestr(replacestr(frmt(wholepas, [pointer(stylepas[dtBackground].color), pointer(stylepas[dtBackground].size)]), '?', stylestrings[dtNormSource]), '?', temp + input);
end;

