program pas2htm;

uses
  windows;

{$APPTYPE CONSOLE}
{$INCLUDE compilerswitches.pas}
{$INCLUDE format.pas}
{$INCLUDE p2h.pas}
{$INCLUDE fileexists.pas}

function GetFileInString(filename: string): string;
var hFileRead, hMapFile: Cardinal;
  pc: pchar;
begin
  result := '';
  case lstrlen(@filename[1]) > 0 of
    TRUE:
      if fileexists(filename) then begin
        hFileRead := CreateFile(@filename[1], GENERIC_READ, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, 0);
        hMapFile := CreateFileMapping(hFileRead, nil, PAGE_READONLY, 0, 0, nil);
        pc := MapViewOfFile(hMapFile, FILE_MAP_READ, 0, 0, 0);
        SetString(result, pc, lstrlen(pc));
        CloseHandle(hMapFile);
        CloseHandle(hFileRead);
      end;
  end;
end;

var fi, source: string;
  SizeWritten, hFileWrite: Cardinal;
  pc: pchar;
begin
  if paramcount > 0 then begin
    if paramstr(2) = '' then fi := paramstr(1) + '.html' else fi := paramstr(2);
    source := GetFileInString(paramstr(1));
    if source <> '' then begin
      source := pas2html(source);
      hFileWrite := CreateFile(@fi[1], GENERIC_READ or GENERIC_WRITE, FILE_SHARE_READ or FILE_SHARE_WRITE, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_ARCHIVE, 0);
      pc := @source[1];
      WriteFile(hFileWrite, pc^, length(source), SizeWritten, nil);
      CloseHandle(hFileWrite);
    end;
  end else writeln('Error, too less parameters ;)' + #13#10 + 'PAS2HTM inputfile [outputfile]');
end.

