{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{                                                       }
{       Copyright (c) 1995,98 Inprise Corporation       }
{                                                       }
{*******************************************************}

(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2000 by -=Assarbad=-                ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)
{
SOME WORDS

The file may now be used with NT also while not impersonated as
administrator. This is/was at least a problem with Delphi 4
I've got Delphi 4 Professional and wondered about these problems.

Note, that this unit has one little incompatibilty with the
native TRegistry object. It uses an array of string instead of
TStrings ;-) ... that's due to reasons of decreasing the code
size.

I also wiped out StrLen() which can be easily replaced by lStrLen
the API version with same function. AllocMem() was replaced with
GetMem() and ZeroMemory() which gives the same effect. Hemce we
save the code introduced by SYSUTILS.PAS ;-)

version 1.32
}

UNIT aRegistry;
INTERFACE

USES Windows;
{$D-,L-,O+,Q-,R-,Y-}
{$HINTS OFF}

CONST
    R=KEY_READ;
    W=KEY_WRITE;
    RW=(KEY_READ OR KEY_WRITE);

TYPE

    TRegKeyInfo=RECORD
        NumSubKeys:Integer;
        MaxSubKeyLen:Integer;
        NumValues:Integer;
        MaxValueLen:Integer;
        MaxDataLen:Integer;
        FileTime:TFileTime;
    END;

    ATStrings=ARRAY OF STRING;

    TRegDataType=(rdUnknown, rdString, rdExpandString, rdInteger, rdBinary);

    TRegDataInfo=RECORD
        RegData:TRegDataType;
        DataSize:Integer;
    END;

    TRegistry=CLASS(TObject)
    Private
        FAccess:DWORD;
        FCurrentKey:HKEY;
        FRootKey:HKEY;
        FLazyWrite:Boolean;
        FCurrentPath:STRING;
        FCloseRootKey:Boolean;
        PROCEDURE SetRootKey(Value:HKEY);
    Protected
        PROCEDURE ChangeKey(Value:HKey;CONST Path:STRING);
        FUNCTION GetBaseKey(Relative:Boolean):HKey;
        FUNCTION GetData(CONST Name:STRING;Buffer:Pointer;
            BufSize:Integer;VAR RegData:TRegDataType):Integer;
        FUNCTION GetKey(CONST Key:STRING):HKEY;
        PROCEDURE PutData(CONST Name:STRING;Buffer:Pointer;BufSize:Integer;RegData:TRegDataType);
        PROCEDURE SetCurrentKey(Value:HKEY);
    Public
        CONSTRUCTOR Create;
        DESTRUCTOR Destroy; Override;
        PROCEDURE CloseKey;
        FUNCTION CreateKey(CONST Key:STRING):Boolean;
        FUNCTION DeleteKey(CONST Key:STRING):Boolean;
        FUNCTION DeleteValue(CONST Name:STRING):Boolean;
        FUNCTION GetDataInfo(CONST ValueName:STRING;VAR Value:TRegDataInfo):Boolean;
        FUNCTION GetDataSize(CONST ValueName:STRING):Integer;
        FUNCTION GetDataType(CONST ValueName:STRING):TRegDataType;
        FUNCTION GetKeyInfo(VAR Value:TRegKeyInfo):Boolean;
        PROCEDURE GetKeyNames(Strings:ATStrings);
        PROCEDURE GetValueNames(VAR Strings:ATStrings);
        FUNCTION HasSubKeys:Boolean;
        FUNCTION KeyExists(CONST Key:STRING):Boolean;
        FUNCTION LoadKey(CONST Key, FileName:STRING):Boolean;
        PROCEDURE MoveKey(CONST OldName, NewName:STRING;Delete:Boolean);
        FUNCTION OpenKey(CONST Key:STRING;CanCreate:Boolean;Access:DWORD):Boolean;
        FUNCTION ReadCurrency(CONST Name:STRING):Currency;
        FUNCTION ReadBinaryData(CONST Name:STRING;VAR Buffer;BufSize:Integer):Integer;
        FUNCTION ReadBool(CONST Name:STRING):Boolean;
        FUNCTION ReadDate(CONST Name:STRING):TDateTime;
        FUNCTION ReadDateTime(CONST Name:STRING):TDateTime;
        FUNCTION ReadFloat(CONST Name:STRING):Double;
        FUNCTION ReadInteger(CONST Name:STRING):Integer;
        FUNCTION ReadString(CONST Name:STRING):STRING;
        FUNCTION ReadTime(CONST Name:STRING):TDateTime;
        FUNCTION RegistryConnect(CONST UNCName:STRING):Boolean;
        PROCEDURE RenameValue(CONST OldName, NewName:STRING);
        FUNCTION ReplaceKey(CONST Key, FileName, BackUpFileName:STRING):Boolean;
        FUNCTION RestoreKey(CONST Key, FileName:STRING):Boolean;
        FUNCTION SaveKey(CONST Key, FileName:STRING):Boolean;
        FUNCTION UnLoadKey(CONST Key:STRING):Boolean;
        FUNCTION ValueExists(CONST Name:STRING):Boolean;
        PROCEDURE WriteCurrency(CONST Name:STRING;Value:Currency);
        PROCEDURE WriteBinaryData(CONST Name:STRING;VAR Buffer;BufSize:Integer);
        PROCEDURE WriteBool(CONST Name:STRING;Value:Boolean);
        PROCEDURE WriteDate(CONST Name:STRING;Value:TDateTime);
        PROCEDURE WriteDateTime(CONST Name:STRING;Value:TDateTime);
        PROCEDURE WriteFloat(CONST Name:STRING;Value:Double);
        PROCEDURE WriteInteger(CONST Name:STRING;Value:Integer);
        PROCEDURE WriteString(CONST Name, Value:STRING);
        PROCEDURE WriteExpandString(CONST Name, Value:STRING);
        PROCEDURE WriteTime(CONST Name:STRING;Value:TDateTime);
        PROPERTY CurrentKey:HKEY Read FCurrentKey;
        PROPERTY CurrentPath:STRING Read FCurrentPath;
        PROPERTY LazyWrite:Boolean Read FLazyWrite Write FLazyWrite;
        PROPERTY RootKey:HKEY Read FRootKey Write SetRootKey;
    END;

IMPLEMENTATION
VAR OSVI:TOSVersionInfo;

CONST
    regerr='Error while handling registry functions.';
    Title='Application error';

PROCEDURE errmsg(msg:STRING);
BEGIN
    MessageBox(0, pchar(msg), pchar(Title), MB_OK OR MB_ICONSTOP OR MB_TASKMODAL);
END;

FUNCTION IsRelative(CONST Value:STRING):Boolean;
BEGIN
    Result:=NOT((Value<>'')AND(Value[1]='\'));
END;

FUNCTION RegDataToDataType(Value:TRegDataType):Integer;
BEGIN
    CASE Value OF
        rdString:Result:=REG_SZ;
        rdExpandString:Result:=REG_EXPAND_SZ;
        rdInteger:Result:=REG_DWORD;
        rdBinary:Result:=REG_BINARY;
    ELSE
        Result:=REG_NONE;
    END;
END;

FUNCTION DataTypeToRegData(Value:Integer):TRegDataType;
BEGIN
    IF Value=REG_SZ THEN Result:=rdString
    ELSE IF Value=REG_EXPAND_SZ THEN Result:=rdExpandString
    ELSE IF Value=REG_DWORD THEN Result:=rdInteger
    ELSE IF Value=REG_BINARY THEN Result:=rdBinary
    ELSE Result:=rdUnknown;
END;

CONSTRUCTOR TRegistry.Create;
BEGIN
    RootKey:=HKEY_CURRENT_USER;
    LazyWrite:=True;
END;

DESTRUCTOR TRegistry.Destroy;
BEGIN
    CloseKey;
    INHERITED;
END;

PROCEDURE TRegistry.CloseKey;
BEGIN
    IF CurrentKey<>0 THEN
    BEGIN
        IF LazyWrite THEN
            RegCloseKey(CurrentKey) ELSE
            RegFlushKey(CurrentKey);
        FAccess:=0;
        FCurrentKey:=0;
        FCurrentPath:='';
    END;
END;

PROCEDURE TRegistry.SetRootKey(Value:HKEY);
BEGIN
    IF RootKey<>Value THEN
    BEGIN
        IF FCloseRootKey THEN
        BEGIN
            RegCloseKey(RootKey);
            FCloseRootKey:=False;
        END;
        FRootKey:=Value;
        CloseKey;
    END;
END;

PROCEDURE TRegistry.ChangeKey(Value:HKey;CONST Path:STRING);
BEGIN
    CloseKey;
    FCurrentKey:=Value;
    FCurrentPath:=Path;
END;

FUNCTION TRegistry.GetBaseKey(Relative:Boolean):HKey;
BEGIN
    IF (CurrentKey=0)OR NOT Relative THEN
        Result:=RootKey ELSE
        Result:=CurrentKey;
END;

PROCEDURE TRegistry.SetCurrentKey(Value:HKEY);
BEGIN
    FCurrentKey:=Value;
END;

FUNCTION TRegistry.CreateKey(CONST Key:STRING):Boolean;
VAR
    TempKey:HKey;
    S:STRING;
    Disposition:Integer;
    Relative:Boolean;
BEGIN
    TempKey:=0;
    S:=Key;
    Relative:=IsRelative(S);
    IF NOT Relative THEN Delete(S, 1, 1);
    Result:=RegCreateKeyEx(GetBaseKey(Relative), PChar(S), 0, NIL,
        REG_OPTION_NON_VOLATILE, RW, NIL, TempKey, @Disposition)=ERROR_SUCCESS;
    IF Result THEN RegCloseKey(TempKey)
    ELSE errmsg(regerr);
END;

FUNCTION TRegistry.OpenKey(CONST Key:STRING;Cancreate:boolean;Access:DWORD):Boolean;
VAR
    TempKey:HKey;
    S:STRING;
    Disposition:Integer;
    Relative:Boolean;
BEGIN
    S:=Key;
    Relative:=IsRelative(S);

    IF NOT Relative THEN Delete(S, 1, 1);
    FAccess:=Access;
    TempKey:=0;
    IF NOT CanCreate OR(S='') THEN
    BEGIN
        Result:=RegOpenKeyEx(GetBaseKey(Relative), PChar(S), 0,
            FAccess, TempKey)=ERROR_SUCCESS;
    END ELSE
        Result:=RegCreateKeyEx(GetBaseKey(Relative), PChar(S), 0, NIL,
            REG_OPTION_NON_VOLATILE, FAccess, NIL, TempKey, @Disposition)=ERROR_SUCCESS;
    IF Result THEN
    BEGIN
        IF (CurrentKey<>0)AND Relative THEN S:=CurrentPath+'\'+S;
        ChangeKey(TempKey, S);
    END;
END;

FUNCTION TRegistry.DeleteKey(CONST Key:STRING):Boolean;
VAR
    Len:DWORD;
    I:Integer;
    Relative:Boolean;
    S, KeyName:STRING;
    OldKey, DeleteKey:HKEY;
    Info:TRegKeyInfo;
BEGIN
    S:=Key;
    Relative:=IsRelative(S);
    IF NOT Relative THEN Delete(S, 1, 1);
    OldKey:=CurrentKey;
    DeleteKey:=GetKey(Key);
    IF DeleteKey<>0 THEN
    TRY
        SetCurrentKey(DeleteKey);
        IF GetKeyInfo(Info) THEN
        BEGIN
            SetString(KeyName, NIL, Info.MaxSubKeyLen+1);
            FOR I:=Info.NumSubKeys-1 DOWNTO 0 DO
            BEGIN
                Len:=Info.MaxSubKeyLen+1;
                IF RegEnumKeyEx(DeleteKey, DWORD(I), PChar(KeyName), Len, NIL, NIL, NIL,
                    NIL)=ERROR_SUCCESS THEN
                    Self.DeleteKey(PChar(KeyName));
            END;
        END;
    FINALLY
        SetCurrentKey(OldKey);
        RegCloseKey(DeleteKey);
    END;
    Result:=RegDeleteKey(GetBaseKey(Relative), PChar(S))=ERROR_SUCCESS;
END;

FUNCTION TRegistry.DeleteValue(CONST Name:STRING):Boolean;
BEGIN
    Result:=RegDeleteValue(CurrentKey, PChar(Name))=ERROR_SUCCESS;
END;

FUNCTION TRegistry.GetKeyInfo(VAR Value:TRegKeyInfo):Boolean;
BEGIN
    FillChar(Value, SizeOf(TRegKeyInfo), 0);
    Result:=RegQueryInfoKey(CurrentKey, NIL, NIL, NIL, @Value.NumSubKeys,
        @Value.MaxSubKeyLen, NIL, @Value.NumValues, @Value.MaxValueLen,
        @Value.MaxDataLen, NIL, @Value.FileTime)=ERROR_SUCCESS;
    OSVI.dwOSVersionInfoSize:=SizeOf(OSVersionInfo);
    GetVersionEx(OSVI);
    IF (GetSystemMetrics(SM_DBCSENABLED)<>0)AND(OSVI.dwPlatformId=VER_PLATFORM_WIN32_NT) THEN
        WITH Value DO BEGIN
            Inc(MaxSubKeyLen, MaxSubKeyLen);
            Inc(MaxValueLen, MaxValueLen);
        END;
END;

PROCEDURE TRegistry.GetKeyNames(Strings:ATStrings);
VAR
    Len:DWORD;
    I:Integer;
    Info:TRegKeyInfo;
    S:STRING;
BEGIN
    setlength(strings, 0);
    IF GetKeyInfo(Info) THEN
    BEGIN
        SetString(S, NIL, Info.MaxSubKeyLen+1);
        FOR I:=0 TO Info.NumSubKeys-1 DO
        BEGIN
            Len:=Info.MaxSubKeyLen+1;
            RegEnumKeyEx(CurrentKey, I, PChar(S), Len, NIL, NIL, NIL, NIL);
            IF Pchar(s)<>NIL THEN BEGIN
                setlength(strings, length(strings)+1);
                strings[length(strings)-1]:=STRING(pchar(s));
            END;
        END;
    END;
END;

PROCEDURE TRegistry.GetValueNames(VAR Strings:ATStrings);
VAR
    Len:DWORD;
    I:Integer;
    Info:TRegKeyInfo;
    S:STRING;
BEGIN
    setlength(strings, 0);
    IF GetKeyInfo(Info) THEN
    BEGIN
        SetString(S, NIL, Info.MaxValueLen+1);
        FOR I:=0 TO Info.NumValues-1 DO
        BEGIN
            Len:=Info.MaxValueLen+1;
            RegEnumValue(CurrentKey, I, PChar(S), Len, NIL, NIL, NIL, NIL);
            IF Pchar(s)<>NIL THEN BEGIN
                setlength(strings, length(strings)+1);
                strings[length(strings)-1]:=STRING(pchar(s));
            END;
        END;
    END;
END;

FUNCTION TRegistry.GetDataInfo(CONST ValueName:STRING;VAR Value:TRegDataInfo):Boolean;
VAR
    DataType:Integer;
BEGIN
    FillChar(Value, SizeOf(TRegDataInfo), 0);
    Result:=RegQueryValueEx(CurrentKey, PChar(ValueName), NIL, @DataType, NIL,
        @Value.DataSize)=ERROR_SUCCESS;
    Value.RegData:=DataTypeToRegData(DataType);
END;

FUNCTION TRegistry.GetDataSize(CONST ValueName:STRING):Integer;
VAR
    Info:TRegDataInfo;
BEGIN
    IF GetDataInfo(ValueName, Info) THEN
        Result:=Info.DataSize ELSE
        Result:=-1;
END;

FUNCTION TRegistry.GetDataType(CONST ValueName:STRING):TRegDataType;
VAR
    Info:TRegDataInfo;
BEGIN
    IF GetDataInfo(ValueName, Info) THEN
        Result:=Info.RegData ELSE
        Result:=rdUnknown;
END;

PROCEDURE TRegistry.WriteString(CONST Name, Value:STRING);
BEGIN
    PutData(Name, PChar(Value), Length(Value)+1, rdString);
END;

PROCEDURE TRegistry.WriteExpandString(CONST Name, Value:STRING);
BEGIN
    PutData(Name, PChar(Value), Length(Value)+1, rdExpandString);
END;

FUNCTION TRegistry.ReadString(CONST Name:STRING):STRING;
VAR
    Len:Integer;
    RegData:TRegDataType;
BEGIN
    Len:=GetDataSize(Name);
    IF Len>0 THEN
    BEGIN
        SetString(Result, NIL, Len);
        GetData(Name, PChar(Result), Len, RegData);
        IF (RegData=rdString)OR(RegData=rdExpandString) THEN
            SetLength(Result, lStrLen(PChar(Result)))
        ELSE errmsg(regerr);
    END
    ELSE Result:='';
END;

PROCEDURE TRegistry.WriteInteger(CONST Name:STRING;Value:Integer);
BEGIN
    PutData(Name, @Value, SizeOf(Integer), rdInteger);
END;

FUNCTION TRegistry.ReadInteger(CONST Name:STRING):Integer;
VAR
    RegData:TRegDataType;
BEGIN
    GetData(Name, @Result, SizeOf(Integer), RegData);
    IF RegData<>rdInteger THEN errmsg(regerr);
END;

PROCEDURE TRegistry.WriteBool(CONST Name:STRING;Value:Boolean);
BEGIN
    WriteInteger(Name, Ord(Value));
END;

FUNCTION TRegistry.ReadBool(CONST Name:STRING):Boolean;
BEGIN
    Result:=ReadInteger(Name)<>0;
END;

PROCEDURE TRegistry.WriteFloat(CONST Name:STRING;Value:Double);
BEGIN
    PutData(Name, @Value, SizeOf(Double), rdBinary);
END;

FUNCTION TRegistry.ReadFloat(CONST Name:STRING):Double;
VAR
    Len:Integer;
    RegData:TRegDataType;
BEGIN
    Len:=GetData(Name, @Result, SizeOf(Double), RegData);
    IF (RegData<>rdBinary)OR(Len<>SizeOf(Double)) THEN
        errmsg(regerr);
END;

PROCEDURE TRegistry.WriteCurrency(CONST Name:STRING;Value:Currency);
BEGIN
    PutData(Name, @Value, SizeOf(Currency), rdBinary);
END;

FUNCTION TRegistry.ReadCurrency(CONST Name:STRING):Currency;
VAR
    Len:Integer;
    RegData:TRegDataType;
BEGIN
    Len:=GetData(Name, @Result, SizeOf(Currency), RegData);
    IF (RegData<>rdBinary)OR(Len<>SizeOf(Currency)) THEN
        errmsg(regerr);
END;

PROCEDURE TRegistry.WriteDateTime(CONST Name:STRING;Value:TDateTime);
BEGIN
    PutData(Name, @Value, SizeOf(TDateTime), rdBinary);
END;

FUNCTION TRegistry.ReadDateTime(CONST Name:STRING):TDateTime;
VAR
    Len:Integer;
    RegData:TRegDataType;
BEGIN
    Len:=GetData(Name, @Result, SizeOf(TDateTime), RegData);
    IF (RegData<>rdBinary)OR(Len<>SizeOf(TDateTime)) THEN
        errmsg(regerr);
END;

PROCEDURE TRegistry.WriteDate(CONST Name:STRING;Value:TDateTime);
BEGIN
    WriteDateTime(Name, Value);
END;

FUNCTION TRegistry.ReadDate(CONST Name:STRING):TDateTime;
BEGIN
    Result:=ReadDateTime(Name);
END;

PROCEDURE TRegistry.WriteTime(CONST Name:STRING;Value:TDateTime);
BEGIN
    WriteDateTime(Name, Value);
END;

FUNCTION TRegistry.ReadTime(CONST Name:STRING):TDateTime;
BEGIN
    Result:=ReadDateTime(Name);
END;

PROCEDURE TRegistry.WriteBinaryData(CONST Name:STRING;VAR Buffer;BufSize:Integer);
BEGIN
    PutData(Name, @Buffer, BufSize, rdBinary);
END;

FUNCTION TRegistry.ReadBinaryData(CONST Name:STRING;VAR Buffer;BufSize:Integer):Integer;
VAR
    RegData:TRegDataType;
    Info:TRegDataInfo;
BEGIN
    IF GetDataInfo(Name, Info) THEN
    BEGIN
        Result:=Info.DataSize;
        RegData:=Info.RegData;
        IF ((RegData=rdBinary)OR(RegData=rdUnknown))AND(Result<=BufSize) THEN
            GetData(Name, @Buffer, Result, RegData)
        ELSE errmsg(regerr);
    END ELSE
        Result:=0;
END;

PROCEDURE TRegistry.PutData(CONST Name:STRING;Buffer:Pointer;
    BufSize:Integer;RegData:TRegDataType);
VAR
    DataType:Integer;
BEGIN
    DataType:=RegDataToDataType(RegData);
    IF RegSetValueEx(CurrentKey, PChar(Name), 0, DataType, Buffer,
        BufSize)<>ERROR_SUCCESS THEN
        errmsg(regerr);
END;

FUNCTION TRegistry.GetData(CONST Name:STRING;Buffer:Pointer;
    BufSize:Integer;VAR RegData:TRegDataType):Integer;
VAR
    DataType:Integer;
BEGIN
    DataType:=REG_NONE;
    IF RegQueryValueEx(CurrentKey, PChar(Name), NIL, @DataType, PByte(Buffer),
        @BufSize)<>ERROR_SUCCESS THEN
        errmsg(regerr);
    Result:=BufSize;
    RegData:=DataTypeToRegData(DataType);
END;

FUNCTION TRegistry.HasSubKeys:Boolean;
VAR
    Info:TRegKeyInfo;
BEGIN
    Result:=GetKeyInfo(Info)AND(Info.NumSubKeys>0);
END;

FUNCTION TRegistry.ValueExists(CONST Name:STRING):Boolean;
VAR
    Info:TRegDataInfo;
BEGIN
    Result:=GetDataInfo(Name, Info);
END;

FUNCTION TRegistry.GetKey(CONST Key:STRING):HKEY;
VAR
    S:STRING;
    Relative:Boolean;
BEGIN
    S:=Key;
    Relative:=IsRelative(S);
    IF NOT Relative THEN Delete(S, 1, 1);
    Result:=0;
    RegOpenKeyEx(GetBaseKey(Relative), PChar(S), 0,
        KEY_ALL_ACCESS, Result);
END;

FUNCTION TRegistry.RegistryConnect(CONST UNCName:STRING):Boolean;
VAR
    TempKey:HKEY;
BEGIN
    Result:=RegConnectRegistry(PChar(UNCname), RootKey, TempKey)=ERROR_SUCCESS;
    IF Result THEN
    BEGIN
        RootKey:=TempKey;
        FCloseRootKey:=True;
    END;
END;

FUNCTION TRegistry.LoadKey(CONST Key, FileName:STRING):Boolean;
VAR
    S:STRING;
BEGIN
    S:=Key;
    IF NOT IsRelative(S) THEN Delete(S, 1, 1);
    Result:=RegLoadKey(RootKey, PChar(S), PChar(FileName))=ERROR_SUCCESS;
END;

FUNCTION TRegistry.UnLoadKey(CONST Key:STRING):Boolean;
VAR
    S:STRING;
BEGIN
    S:=Key;
    IF NOT IsRelative(S) THEN Delete(S, 1, 1);
    Result:=RegUnLoadKey(RootKey, PChar(S))=ERROR_SUCCESS;
END;

FUNCTION TRegistry.RestoreKey(CONST Key, FileName:STRING):Boolean;
VAR
    RestoreKey:HKEY;
BEGIN
    Result:=False;
    RestoreKey:=GetKey(Key);
    IF RestoreKey<>0 THEN
    TRY
        Result:=RegRestoreKey(RestoreKey, PChar(FileName), 0)=ERROR_SUCCESS;
    FINALLY
        RegCloseKey(RestoreKey);
    END;
END;

FUNCTION TRegistry.ReplaceKey(CONST Key, FileName, BackUpFileName:STRING):Boolean;
VAR
    S:STRING;
    Relative:Boolean;
BEGIN
    S:=Key;
    Relative:=IsRelative(S);
    IF NOT Relative THEN Delete(S, 1, 1);
    Result:=RegReplaceKey(GetBaseKey(Relative), PChar(S),
        PChar(FileName), PChar(BackUpFileName))=ERROR_SUCCESS;
END;

FUNCTION TRegistry.SaveKey(CONST Key, FileName:STRING):Boolean;
VAR
    SaveKey:HKEY;
BEGIN
    Result:=False;
    SaveKey:=GetKey(Key);
    IF SaveKey<>0 THEN
    TRY
        Result:=RegSaveKey(SaveKey, PChar(FileName), NIL)=ERROR_SUCCESS;
    FINALLY
        RegCloseKey(SaveKey);
    END;
END;

FUNCTION TRegistry.KeyExists(CONST Key:STRING):Boolean;
VAR
    TempKey:HKEY;
BEGIN
    TempKey:=GetKey(Key);
    IF TempKey<>0 THEN RegCloseKey(TempKey);
    Result:=TempKey<>0;
END;

PROCEDURE TRegistry.RenameValue(CONST OldName, NewName:STRING);
VAR
    Len:Integer;
    RegData:TRegDataType;
    Buffer:PChar;
BEGIN
    IF ValueExists(OldName)AND NOT ValueExists(NewName) THEN
    BEGIN
        Len:=GetDataSize(OldName);
        IF Len>0 THEN
        BEGIN
            GetMem(Buffer, Len);
            ZeroMemory(Buffer, Len);
            TRY
                Len:=GetData(OldName, Buffer, Len, RegData);
                DeleteValue(OldName);
                PutData(NewName, Buffer, Len, RegData);
            FINALLY
                FreeMem(Buffer);
            END;
        END;
    END;
END;

PROCEDURE TRegistry.MoveKey(CONST OldName, NewName:STRING;Delete:Boolean);
VAR
    SrcKey, DestKey:HKEY;

    PROCEDURE MoveValue(SrcKey, DestKey:HKEY;CONST Name:STRING);
    VAR
        Len:Integer;
        OldKey, PrevKey:HKEY;
        Buffer:PChar;
        RegData:TRegDataType;
    BEGIN
        OldKey:=CurrentKey;
        SetCurrentKey(SrcKey);
        TRY
            Len:=GetDataSize(Name);
            IF Len>0 THEN
            BEGIN
                GetMem(Buffer, Len);
                ZeroMemory(Buffer, Len);
                TRY
                    Len:=GetData(Name, Buffer, Len, RegData);
                    PrevKey:=CurrentKey;
                    SetCurrentKey(DestKey);
                    TRY
                        PutData(Name, Buffer, Len, RegData);
                    FINALLY
                        SetCurrentKey(PrevKey);
                    END;
                FINALLY
                    FreeMem(Buffer);
                END;
            END;
        FINALLY
            SetCurrentKey(OldKey);
        END;
    END;

    PROCEDURE CopyValues(SrcKey, DestKey:HKEY);
    VAR
        Len:DWORD;
        I:Integer;
        KeyInfo:TRegKeyInfo;
        S:STRING;
        OldKey:HKEY;
    BEGIN
        OldKey:=CurrentKey;
        SetCurrentKey(SrcKey);
        TRY
            IF GetKeyInfo(KeyInfo) THEN
            BEGIN
                MoveValue(SrcKey, DestKey, '');
                SetString(S, NIL, KeyInfo.MaxValueLen+1);
                FOR I:=0 TO KeyInfo.NumValues-1 DO
                BEGIN
                    Len:=KeyInfo.MaxValueLen+1;
                    IF RegEnumValue(SrcKey, I, PChar(S), Len, NIL, NIL, NIL, NIL)=ERROR_SUCCESS THEN
                        MoveValue(SrcKey, DestKey, PChar(S));
                END;
            END;
        FINALLY
            SetCurrentKey(OldKey);
        END;
    END;

    PROCEDURE CopyKeys(SrcKey, DestKey:HKEY);
    VAR
        Len:DWORD;
        I:Integer;
        Info:TRegKeyInfo;
        S:STRING;
        OldKey, PrevKey, NewSrc, NewDest:HKEY;
    BEGIN
        OldKey:=CurrentKey;
        SetCurrentKey(SrcKey);
        TRY
            IF GetKeyInfo(Info) THEN
            BEGIN
                SetString(S, NIL, Info.MaxSubKeyLen+1);
                FOR I:=0 TO Info.NumSubKeys-1 DO
                BEGIN
                    Len:=Info.MaxSubKeyLen+1;
                    IF RegEnumKeyEx(SrcKey, I, PChar(S), Len, NIL, NIL, NIL, NIL)=ERROR_SUCCESS THEN
                    BEGIN
                        NewSrc:=GetKey(PChar(S));
                        IF NewSrc<>0 THEN
                        TRY
                            PrevKey:=CurrentKey;
                            SetCurrentKey(DestKey);
                            TRY
                                CreateKey(PChar(S));
                                NewDest:=GetKey(PChar(S));
                                TRY
                                    CopyValues(NewSrc, NewDest);
                                    CopyKeys(NewSrc, NewDest);
                                FINALLY
                                    RegCloseKey(NewDest);
                                END;
                            FINALLY
                                SetCurrentKey(PrevKey);
                            END;
                        FINALLY
                            RegCloseKey(NewSrc);
                        END;
                    END;
                END;
            END;
        FINALLY
            SetCurrentKey(OldKey);
        END;
    END;

BEGIN
    IF KeyExists(OldName)AND NOT KeyExists(NewName) THEN
    BEGIN
        SrcKey:=GetKey(OldName);
        IF SrcKey<>0 THEN
        TRY
            CreateKey(NewName);
            DestKey:=GetKey(NewName);
            IF DestKey<>0 THEN
            TRY
                CopyValues(SrcKey, DestKey);
                CopyKeys(SrcKey, DestKey);
                IF Delete THEN DeleteKey(OldName);
            FINALLY
                RegCloseKey(DestKey);
            END;
        FINALLY
            RegCloseKey(SrcKey);
        END;
    END;
END;

END.
