(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2001 by -=Assarbad=-                ***
 ***                                                          ***
 ***    May the source be with you, stranger ... :-)          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)
(*******************************************************************************
 version 2.0

 - omitted some functions that are not necessary.
 - enhanced readkey. now waits for event, instead of polling for event.
 - the "std_*" variables can now be used outside InitConsole.
 - SetTextAttribute now returns the old text attributes in a word.
   The behavior is transparent, since Delphi allows functions to be called like
   procedures (without taking back any return value).
 *******************************************************************************)

var
  std_input,
    std_output,
    std_error: THandle;

procedure InitConsole;
begin
  std_input := GetStdHandle(STD_INPUT_HANDLE);
  std_output := GetStdHandle(STD_OUTPUT_HANDLE);
  std_error := GetStdHandle(STD_ERROR_HANDLE);
  SetStdHandle(STD_ERROR_HANDLE, std_input);
end;

function TextAttribute: Word;
var
  csbi: _CONSOLE_SCREEN_BUFFER_INFO;
begin
  if GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), csbi) then
    result := csbi.wAttributes
  else
    result := 0;
end;

function SetTextAttribute(attr: word): word;
var
  oldattr: word;
begin
  oldattr := TextAttribute;
  if SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), attr) then
    result := oldattr
  else
    result := 0;
end;

procedure ClrScr;
var
  tc: tcoord;
  nw: Cardinal;
  cbi: TConsoleScreenBufferInfo;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), cbi);
  tc.x := 0;
  tc.y := 0;
  FillConsoleOutputAttribute(GetStdHandle(STD_OUTPUT_HANDLE), textattribute, cbi.dwsize.x * cbi.dwsize.y, tc, nw);
  FillConsoleOutputCharacter(GetStdHandle(STD_OUTPUT_HANDLE), #32, cbi.dwsize.x * cbi.dwsize.y, tc, nw);
  SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), tc);
end;

function WhereX: Integer;
var
  cbi: TConsoleScreenBufferInfo;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), cbi);
  result := TCoord(cbi.dwCursorPosition).x + 1
end;

function WhereY: Integer;
var
  cbi: TConsoleScreenBufferInfo;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), cbi);
  result := TCoord(cbi.dwCursorPosition).y + 1
end;

procedure GotoXY(const x, y: integer);
var
  coord: TCoord;
begin
  coord.x := x - 1;
  coord.y := y - 1;
  SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), coord);
end;

procedure FlushInputBuffer;
begin
  FlushConsoleInputBuffer(GetStdHandle(STD_INPUT_HANDLE))
end;

function ReadKey: Char;
var
  NumRead: Cardinal;
  InputRec: TInputRecord;
  ConHandle: THandle;
begin
  ConHandle := GetStdHandle(STD_INPUT_HANDLE);
  while not (
    (WaitForSingleObject(ConHandle, INFINITE) = WAIT_OBJECT_0) and
    ReadConsoleInput(ConHandle, InputRec, 1, NumRead) and
    (InputRec.EventType = KEY_EVENT)) do
    ;
  Result := InputRec.Event.KeyEvent.AsciiChar;
  FlushConsoleInputBuffer(ConHandle);
end;

function Keypressed: boolean;
var
  NumberOfEvents: Cardinal;
begin
  GetNumberOfConsoleInputEvents(GetStdHandle(STD_INPUT_HANDLE), NumberOfEvents);
  result := NumberOfEvents <> 0;
end;

