program yesno;

uses windows;
{$APPTYPE CONSOLE}
{$INCLUDE ConsoleHlp.pas}

{
------
first parameter is a set of chars possible to press. the order defines the
return value:
 - first -> 1
 - maximum last -> 254
 - if an error occured the return value is FALSE=0
no more than 255 characters are supported for the first parameter.

------
second parameter is a textual string to output right before waiting for input

------
third parameter is optional "/i". this denotes wether to parse input case
insensitive (/i) or case sensitive (no 3rd param)


Note, the first existance of a character in the first parameter is counted.
If the character exists more than once, always the first is counted - this may
even lead to shifts in order.
}

var
  i: integer;
  c: char;
  keys: set of char;
  s1: string;
  casenonsensitive: boolean;
  oldattr:Word;
begin
  InitConsole;
  FlushInputBuffer;
  casenonsensitive := lstrcmpi(@paramstr(3)[1], '/I') = 0;
  if paramstr(1) <> '' then
    begin
      // no param 2 if no param 1 ;)
      if paramstr(2) <> '' then
        write(paramstr(2));
      s1 := paramstr(1);
      i := length(s1);
      if i > $FF then
        halt(0);
      keys := [];
      case casenonsensitive of
        true:
          s1 := charupper(@s1[1]);
      end;
      for i := 1 to i do
        begin
          if not (s1[i] in keys) then
            keys := keys + [s1[i]];
        end;
      keys := keys + [#27]; //ESC
      case casenonsensitive of
        true:
          repeat
            c := readkey;
            if c in ['a'..'z'] then
              c := chr(ord(c) - $20); // make uppercase
            // ATTENTION this is not case sensitive!!!
          until c in keys;
      else
        repeat
          c := readkey;
          // ATTENTION this is case sensitive!!!
        until c in keys;
      end;
      oldattr:=SetTextAttribute(FOREGROUND_BLUE or FOREGROUND_INTENSITY);
      writeln(' [' + c + ']');
      SetTextAttribute(oldattr);
      for i := 1 to length(s1) do
        if c = s1[i] then
          halt(i);
    end;
  halt(0);
end.

