(****************************************************************
 ****************************************************************
 ***                                                          ***
 ***        Copyright (c) 2001 by -=Assarbad=-                ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************)

program uptime;
uses
  Windows, Messages;

{$R main.res}
{$R icon.res}
{$INCLUDE ATOI.pas}

const
  IDD_DIALOG1 = 101;
  IDC_STATIC_UPTIME = 1001;
  ID_TIMER = 1;
var
  desktoprect: TRect;
  timer: Cardinal = 0;
  blackbrush, fix8: Cardinal;
  LogBrush: TLogBrush = (
    lbStyle: BS_SOLID;
    lbColor: $00000000;
    lbHatch: 0);

function HoldOnDesktop(hwnd: hwnd; umsg: Cardinal; wparam: wparam; lparam: lparam; snapping: boolean): bool;
//FUNCTION um das Fenster innerhalb der WORKAREA zu halten.
const
  defaultsnapgridsize = 10;
var
  size: TSize;
  snapgridsize: integer;
begin
  case snapping of
    true: snapgridsize := defaultsnapgridsize;
  else snapgridsize := 0;
  end;
  size.cx := PRECT(lParam).right - PRECT(lParam).left;
  size.cy := PRECT(lParam).bottom - PRECT(lParam).top;
  if PRECT(lParam).left < desktoprect.Left + snapgridsize then begin
    PRECT(lParam).left := desktoprect.Left;
    PRECT(lParam).right := PRECT(lParam).left + size.cx;
  end;
  if PRECT(lParam).right > desktoprect.Right - snapgridsize then begin
    PRECT(lParam).right := desktoprect.Right;
    PRECT(lParam).left := PRECT(lParam).right - size.cx;
  end;
  if PRECT(lParam).top < desktoprect.top + snapgridsize then begin
    PRECT(lParam).top := desktoprect.top;
    PRECT(lParam).bottom := PRECT(lParam).top + size.cy;
  end;
  if PRECT(lParam).bottom > desktoprect.bottom - snapgridsize then begin
    PRECT(lParam).bottom := desktoprect.bottom;
    PRECT(lParam).top := PRECT(lParam).bottom - size.cy;
  end;
  result := true;
end;

function ChangeDisp(hwnd: hwnd; umsg: Cardinal; wparam: wparam; lparam: lparam): bool;
var rect: TRect;

  procedure doit;
  begin
    SystemParametersInfo(SPI_GETWORKAREA, 0, @desktoprect, 0);
    GetWindowrect(hwnd, rect);
    MoveWindow(hwnd, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, false);
  end;

begin
  result := TRUE;
  case umsg of
    WM_DISPLAYCHANGE: doit;
    WM_SETTINGCHANGE:
      case wParam of
        SPI_SETWORKAREA:
          doit;
      end;
  else result := FALSE;
  end;
end;

function gettime: string;
var t: LongWord;
begin
  t := GetTickCount;
  result := _inttostr(t mod 1000);
  case t mod 1000 < 100 of
    true: result := '0' + result;
  end;
  t := t div 1000; // -> seconds
  result := _inttostr(t mod 60) + '.' + result;
  case t mod 60 < 10 of
    true: result := '0' + result;
  end;
  t := t div 60; //minutes
  result := _inttostr(t mod 60) + 'm ' + result;
  case t mod 60 < 10 of
    true: result := '0' + result;
  end;
  t := t div 60; //hours
  result := _inttostr(t mod 24) + 'h ' + result;
  case t mod 60 < 10 of
    true: result := '0' + result;
  end;
  result := _inttostr(t div 24) + 'd ' + result + 's'; ;
end;

function dlgfunc(hwnd: hwnd; umsg: Cardinal; wparam: wparam; lparam: lparam): bool; stdcall;
var
  temp: string;
begin
  Result := TRUE;
  case umsg of
    WM_INITDIALOG:
      begin
        fix8 := CreateFont(-MulDiv(10, GetDeviceCaps(GetWindowDC(hwnd), LOGPIXELSY), 72), 0, 0, 0, FW_NORMAL, 0, 0, 0, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH or FF_MODERN, 'Courier New');
        sendmessage(Getdlgitem(hwnd, IDC_STATIC_UPTIME), WM_SETFONT, fix8, Integer(TRUE));
        temp := gettime;
        setdlgitemtext(hwnd, IDC_STATIC_UPTIME, @temp[1]);
        timer := SetTimer(hWnd, ID_TIMER, 500, nil);
      end;
    WM_CLOSE:
      begin
        if timer <> 0 then killtimer(hwnd, timer);
        EndDialog(hwnd, 0);
      end;
    WM_CTLCOLORSTATIC:
      begin
        SetTextColor(wParam, RGB($00, $FF, $00));
        SetBkColor(wParam, LogBrush.lbColor);
        result := BOOL(blackbrush);
      end;
    WM_CTLCOLORDLG:
      result := BOOL(blackbrush);
    WM_LBUTTONDOWN:
      sendmessage(hwnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam);
    WM_TIMER:
      begin
        temp := gettime;
        setdlgitemtext(hwnd, IDC_STATIC_UPTIME, @temp[1]);
      end;
    WM_MOVING:
//Da diese Funktion mehr als einmal gebraucht wird, wurde sie ausgelagert.
//So kann das Fenster nicht aus dem Desktop geschoben werden.
//Ist zB die Taskbar sichtbar, wird diese ausgeklammert ;)
      result := HoldOnDesktop(hwnd, umsg, wparam, lparam, false);
    WM_DISPLAYCHANGE,
      WM_SETTINGCHANGE:
//Wenn die Working area sich ndert, -> Fenster anpassen
      result := changedisp(hwnd, umsg, wparam, lparam);
    WM_COMMAND:
      case HiWord(WParam) of
        BN_CLICKED:
          case LOWORD(wParam) of
            IDOK: sendmessage(hwnd, WM_CLOSE, 0, 0);
          end;
      end;
  else result := false;
  end;
end;

function cutpath(s: string): string;
//entweder dateinamen holen oder ansonsten bernehmen
var i: integer;
begin
  result := s;
  for i := length(s) downto 1 do
//von hinten den backslash suchen. wenn gefunden alles ab backslash kopieren
    if s[i] = '\' then begin
      result := copy(s, i + 1, length(s));
      break;
    end;
end;

begin
  blackbrush := CreateBrushIndirect(LogBrush);
  SystemParametersInfo(SPI_GETWORKAREA, 0, @desktoprect, 0);
  DialogBoxParam(HInstance, MAKEINTRESOURCE(IDD_DIALOG1), 0, @dlgfunc, 0);
end.

